/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileTool {
    public static void copy(File src, File target, boolean excludeCVS) throws IOException {
        if (src.getName().equals("CVS") && excludeCVS) {
            return;
        }
        if (src.isFile() && target.isFile()) {
            FileTool.fileCopy(src, target);
        } else if (src.isFile() && target.isDirectory()) {
            FileTool.fileCopy(src, new File(target, src.getName()));
        } else {
            if (src.isDirectory() && target.isFile()) {
                throw new IOException("Unable to copy a dir->file.");
            }
            File[] srcFiles = src.listFiles();
            for (int t = 0; t < srcFiles.length; ++t) {
                File targetFile = new File(target, srcFiles[t].getName());
                if (srcFiles[t].isDirectory()) {
                    targetFile.mkdir();
                    FileTool.copy(srcFiles[t], targetFile, excludeCVS);
                    continue;
                }
                FileTool.fileCopy(srcFiles[t], targetFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File target) throws IOException {
        long length = src.length();
        byte[] buffer = new byte[8192];
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(src));
        try {
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(target));
            try {
                int r;
                int sum = 0;
                do {
                    if ((r = ((InputStream)fin).read(buffer)) < 0) {
                        throw new IOException("Read less bytes than expected.");
                    }
                    fout.write(buffer, 0, r);
                } while ((long)(sum += r) < length);
            }
            finally {
                fout.close();
            }
        }
        finally {
            ((InputStream)fin).close();
        }
    }
}

