/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class PowerBarPanel
extends JPanel {
    private int entryLabelWidth = 128;
    private int verticalBarWidth = 8;
    private int entryHeight = 42;
    private Font boldFont;
    private Font plainFont;
    private Color vericalBarColor;
    private Color entryLabelColor;
    private Color entryTextColor;
    private Color labelTextColor;
    private Color[] barColors;
    private List myEntries = new ArrayList();

    public PowerBarPanel() {
        this.boldFont = new Font("Verdana", 1, 12);
        this.plainFont = new Font("Verdana", 0, 11);
        this.vericalBarColor = new Color(64, 64, 128);
        this.entryLabelColor = new Color(128, 128, 192);
        this.entryTextColor = new Color(255, 255, 255);
        this.labelTextColor = new Color(64, 64, 64);
        this.barColors = new Color[]{new Color(192, 128, 128), new Color(192, 192, 128), new Color(128, 192, 128), new Color(128, 160, 192), new Color(128, 128, 192)};
    }

    public void setFonts(Font bold, Font plain) {
        this.boldFont = bold;
        this.plainFont = plain;
    }

    public void setBarColors(Color[] col) {
        if (col == null) {
            throw new NullPointerException("Cannot set NULL Colors.");
        }
        this.barColors = col;
    }

    public void setSizes(int height, int labelWidth, int barWidth) {
        this.entryHeight = height;
        this.entryLabelWidth = labelWidth;
        this.verticalBarWidth = barWidth;
    }

    public void setColors(Color labelBackgroundColor, Color labelTextColor, Color barTextColor, Color verticalBarColor) {
        this.vericalBarColor = verticalBarColor;
        this.entryLabelColor = labelBackgroundColor;
        this.entryTextColor = labelTextColor;
        this.labelTextColor = barTextColor;
    }

    public void addEntry(Entry e) {
        if (e == null) {
            throw new NullPointerException("Cannot add a NULL entry.");
        }
        this.myEntries.add(e);
        this.setPreferredSize(new Dimension(0, this.myEntries.size() * this.entryHeight));
        this.invalidate();
    }

    public void removeEntry(Entry e) {
        int idx = this.myEntries.indexOf(e);
        if (idx < 0) {
            throw new NullPointerException("Entry not found.");
        }
        this.myEntries.remove(idx);
        this.setPreferredSize(new Dimension(0, this.myEntries.size() * this.entryHeight));
        this.invalidate();
    }

    public int getMax() {
        int mx = 0;
        for (int t = 0; t < this.myEntries.size(); ++t) {
            Entry e = (Entry)this.myEntries.get(t);
            int sum = 0;
            for (int y = 0; y < e.getLength(); ++y) {
                sum += e.getValue(y);
            }
            if (sum <= mx) continue;
            mx = sum;
        }
        return mx;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double mx = this.getMax();
        if (mx == 0.0) {
            mx = 1.0;
        }
        double width = this.getWidth() - this.entryLabelWidth;
        double pixPerPoint = width / mx;
        g.setColor(this.vericalBarColor);
        g.fillRect(this.entryLabelWidth + 1, 0, this.verticalBarWidth, this.getHeight());
        for (int t = 0; t < this.myEntries.size(); ++t) {
            Entry e = (Entry)this.myEntries.get(t);
            g.setColor(this.entryLabelColor);
            g.fillRect(0, t * this.entryHeight, this.entryLabelWidth, this.entryHeight - 1);
            g.setFont(this.boldFont);
            g.setColor(this.entryTextColor);
            int w = g.getFontMetrics().stringWidth(e.getLabel());
            g.drawString(e.getLabel(), this.entryLabelWidth - 8 - w, t * this.entryHeight + this.entryHeight / 3);
            g.setFont(this.plainFont);
            w = g.getFontMetrics().stringWidth(e.getSubLabel());
            g.drawString(e.getSubLabel(), this.entryLabelWidth - 8 - w, t * this.entryHeight + this.entryHeight * 2 / 3);
            int cx = this.entryLabelWidth + 1 + this.verticalBarWidth + 1;
            for (int y = 0; y < e.getLength(); ++y) {
                g.setColor(y < this.barColors.length ? this.barColors[y] : Color.white);
                int nx = (int)((double)e.getValue(y) * pixPerPoint);
                g.fillRect(cx, t * this.entryHeight, nx, this.entryHeight - 1);
                String vlbl = e.getValueLabel(y);
                g.setFont(this.plainFont);
                w = g.getFontMetrics().stringWidth(vlbl);
                if (w < nx) {
                    g.setColor(this.labelTextColor);
                    g.drawString(vlbl, cx + nx / 2 - w / 2, t * this.entryHeight + this.entryHeight * 2 / 3);
                }
                vlbl = e.getTextLabel(y);
                g.setFont(this.boldFont);
                w = g.getFontMetrics().stringWidth(vlbl);
                if (w < nx) {
                    g.setColor(this.labelTextColor);
                    g.drawString(vlbl, cx + nx / 2 - w / 2, t * this.entryHeight + this.entryHeight * 1 / 3);
                }
                cx = cx + nx + (nx > 0 ? 1 : 0);
            }
        }
    }

    public static class SimpleEntry
    implements Entry {
        private String myLbl;
        private String mySub;
        private int[] myValues;
        private String[] myValueLabels;
        private String[] myTextLabels;

        public SimpleEntry(String lbl, String sub, int[] v, String[] textLabels, String[] valueLabels) {
            this.myLbl = lbl;
            this.mySub = sub;
            this.myValues = v;
            this.myValueLabels = valueLabels;
            this.myTextLabels = textLabels;
        }

        @Override
        public String getLabel() {
            return this.myLbl;
        }

        @Override
        public String getSubLabel() {
            return this.mySub;
        }

        @Override
        public int getLength() {
            return this.myValues.length;
        }

        @Override
        public int getValue(int nr) {
            return this.myValues[nr];
        }

        @Override
        public String getValueLabel(int nr) {
            if (nr >= this.myValueLabels.length) {
                return "";
            }
            return this.myValueLabels[nr];
        }

        @Override
        public String getTextLabel(int nr) {
            if (nr >= this.myTextLabels.length) {
                return "";
            }
            return this.myTextLabels[nr];
        }
    }

    public static interface Entry {
        public int getLength();

        public int getValue(int var1);

        public String getLabel();

        public String getSubLabel();

        public String getTextLabel(int var1);

        public String getValueLabel(int var1);
    }
}

