/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ChartPanel
extends JPanel {
    private List mySeries = new ArrayList();
    private List myRenderers = new ArrayList();
    private int myLeft;
    private int myRight;
    private int myTop;
    private int myBottom;
    private boolean myIsFloating;
    private AxisRenderer myAxis = new SimpleAxisRenderer();

    public ChartPanel() {
        this.setBackground(Color.white);
    }

    public ChartPanel(Series[] sr) {
        this.addSeries(sr);
        this.setBackground(Color.white);
    }

    public void addSeries(Series[] sr) {
        for (int t = 0; t < sr.length; ++t) {
            this.addSeries(sr[t]);
        }
    }

    public void addSeries(Series sr) {
        this.addSeries(sr, new LineRenderer());
    }

    public void addSeries(Series sr, ChartRenderer renderer) {
        if (sr == null) {
            throw new NullPointerException("Cannot add a NULL Series.");
        }
        if (renderer == null) {
            throw new NullPointerException("Cannot add a NULL Renderer.");
        }
        this.mySeries.add(sr);
        this.myRenderers.add(renderer);
    }

    public void removeSeries(Series sr) {
        int idx = this.mySeries.indexOf(sr);
        if (idx < 0) {
            throw new NullPointerException("This series is not in this Chart.");
        }
        this.mySeries.remove(idx);
        this.myRenderers.remove(idx);
    }

    public Series[] getSeries() {
        return this.mySeries.toArray(new Series[this.mySeries.size()]);
    }

    public int getBottom() {
        int min = Integer.MAX_VALUE;
        if (!this.myIsFloating) {
            min = 0;
        }
        for (int t = 0; t < this.mySeries.size(); ++t) {
            Series s = (Series)this.mySeries.get(t);
            if (s.getBottom() >= min) continue;
            min = s.getBottom();
        }
        return min;
    }

    public int getTop() {
        int max = Integer.MIN_VALUE;
        for (int t = 0; t < this.mySeries.size(); ++t) {
            Series s = (Series)this.mySeries.get(t);
            if (s.getTop() <= max) continue;
            max = s.getTop();
        }
        return max;
    }

    public int getLength() {
        int max = Integer.MIN_VALUE;
        for (int t = 0; t < this.mySeries.size(); ++t) {
            Series s = (Series)this.mySeries.get(t);
            if (s.getLength() <= max) continue;
            max = s.getLength();
        }
        return max;
    }

    public void setInnerMargins(int left, int right, int top, int bottom) {
        this.myLeft = left;
        this.myRight = right;
        this.myTop = top;
        this.myBottom = bottom;
    }

    public void setFloating(boolean f) {
        this.myIsFloating = f;
    }

    @Override
    public void paint(Graphics g) {
        int value;
        ChartRenderer renderer;
        int s;
        int pos;
        int t;
        if (this.mySeries.size() == 0) {
            return;
        }
        int bottom = this.getBottom();
        int top = this.getTop();
        int length = this.getLength();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int width = this.getWidth() - this.myLeft - this.myRight;
        int height = this.getHeight() - this.myTop - this.myBottom;
        double pixelX = (double)width / (length == 0 ? 1.0 : (double)length);
        double pixelY = (double)height / (top - bottom == 0 ? 1.0 : (double)(top - bottom));
        int zeroLine = this.myTop + height + (int)((double)bottom * pixelY);
        this.myAxis.renderYAxis(g, zeroLine, bottom, top, pixelY, this.myLeft, width);
        this.myAxis.renderXAxis(g, this.myLeft, 0, length, pixelX, zeroLine, height);
        Series[] series = this.getSeries();
        int[] lastValue = new int[series.length];
        for (int t2 = 0; t2 < lastValue.length; ++t2) {
            lastValue[t2] = zeroLine;
        }
        int lastPos = this.myLeft;
        for (t = 0; t < length; ++t) {
            pos = this.myLeft + this.translate(t + 1, pixelX);
            for (s = 0; s < series.length; ++s) {
                renderer = (ChartRenderer)this.myRenderers.get(s);
                if (t >= series[s].getLength()) continue;
                value = series[s].getValue(t);
                value = this.myTop + height - this.translate(value - bottom, pixelY);
                renderer.renderValue(g, pos, lastPos, value, lastValue[s], t, s, zeroLine);
                lastValue[s] = value;
            }
            lastPos = pos;
        }
        lastValue = new int[series.length];
        for (t = 0; t < lastValue.length; ++t) {
            lastValue[t] = zeroLine;
        }
        lastPos = this.myLeft;
        for (t = 0; t < length; ++t) {
            pos = this.myLeft + this.translate(t + 1, pixelX);
            for (s = 0; s < series.length; ++s) {
                renderer = (ChartRenderer)this.myRenderers.get(s);
                if (t >= series[s].getLength()) continue;
                value = series[s].getValue(t);
                value = this.myTop + height - this.translate(value - bottom, pixelY);
                renderer.renderMarker(g, pos, lastPos, value, lastValue[s], t, s, zeroLine);
                lastValue[s] = value;
            }
            lastPos = pos;
        }
    }

    protected int translate(double value, double pixelY) {
        return (int)Math.round(value * pixelY);
    }

    public static class SimpleAxisRenderer
    implements AxisRenderer {
        @Override
        public void renderXAxis(Graphics g, int ofs, int left, int right, double scale, int ypos, int height) {
            g.setColor(Color.gray);
            g.drawLine((int)((double)ofs + (double)left * scale), ypos, (int)((double)ofs + (double)right * scale), ypos);
            for (int t = left + 1; t < right; ++t) {
                g.setColor(Color.lightGray);
                g.drawLine((int)((double)ofs + (double)t * scale), ypos - height, (int)((double)ofs + (double)t * scale), ypos + 2);
                g.setColor(Color.gray);
                g.drawLine((int)((double)ofs + (double)t * scale), ypos - 2, (int)((double)ofs + (double)t * scale), ypos + 2);
            }
        }

        @Override
        public void renderYAxis(Graphics g, int ofs, int bottom, int top, double scale, int xpos, int width) {
            int tmp = top - bottom;
            int mul = 1;
            while (tmp / 25 > 0) {
                tmp /= 5;
                mul *= 5;
            }
            for (int p = bottom = bottom / mul * mul; p <= top; p += mul) {
                g.setColor(Color.gray);
                g.drawLine(xpos - 2, (int)((double)ofs - (double)p * scale), xpos + 2, (int)((double)ofs - (double)p * scale));
                g.setColor(Color.lightGray);
                g.drawLine(xpos + 3, (int)((double)ofs - (double)p * scale), xpos + width, (int)((double)ofs - (double)p * scale));
            }
            g.setColor(Color.gray);
            g.drawLine(xpos, (int)((double)ofs - (double)bottom * scale), xpos, (int)((double)ofs - (double)top * scale));
        }
    }

    public static class BarRenderer
    implements ChartRenderer {
        private static final int MARGIN = 8;
        private static final int ZEFFECT = 4;
        private Color myColor;

        public BarRenderer() {
            this.myColor = Color.BLACK;
        }

        public BarRenderer(Color color) {
            this.myColor = color;
        }

        @Override
        public void renderValue(Graphics g, int x, int px, int y, int py, int count, int z, int zeroLine) {
            int[] xx = new int[]{(px += 8) + z * 4, px + z * 4, (x -= 8) + z * 4, x + z * 4};
            int[] yy = new int[]{zeroLine + z * 4, y + z * 4, y + z * 4, zeroLine + z * 4};
            g.setColor(this.myColor);
            g.fillPolygon(xx, yy, xx.length);
            g.setColor(this.myColor.darker());
            g.drawPolygon(xx, yy, xx.length);
        }

        @Override
        public void renderMarker(Graphics g, int x, int px, int y, int py, int count, int z, int height) {
        }
    }

    public static class LineRenderer
    implements ChartRenderer {
        private Color myColor;

        public LineRenderer() {
            this.myColor = Color.BLACK;
        }

        public LineRenderer(Color color) {
            this.myColor = color;
        }

        @Override
        public void renderValue(Graphics g, int x, int px, int y, int py, int count, int z, int height) {
            g.setColor(this.myColor);
            g.drawLine(px, py, x, y);
        }

        @Override
        public void renderMarker(Graphics g, int x, int px, int y, int py, int count, int z, int height) {
            g.setColor(this.myColor);
            g.drawRoundRect(x - 3, y - 3, 7, 7, 2, 2);
        }
    }

    public static class ArraySeries
    implements Series {
        private int[] myValues;
        private int myTop;
        private int myBottom;

        public ArraySeries(int[] values) {
            this.myValues = values;
            this.myTop = Integer.MIN_VALUE;
            this.myBottom = Integer.MAX_VALUE;
            for (int t = 0; t < values.length; ++t) {
                if (values[t] > this.myTop) {
                    this.myTop = values[t];
                }
                if (values[t] >= this.myBottom) continue;
                this.myBottom = values[t];
            }
        }

        @Override
        public int getLength() {
            return this.myValues.length;
        }

        @Override
        public int getTop() {
            return this.myTop;
        }

        @Override
        public int getBottom() {
            return this.myBottom;
        }

        @Override
        public int getValue(int nr) {
            return this.myValues[nr];
        }
    }

    public static interface AxisRenderer {
        public void renderXAxis(Graphics var1, int var2, int var3, int var4, double var5, int var7, int var8);

        public void renderYAxis(Graphics var1, int var2, int var3, int var4, double var5, int var7, int var8);
    }

    public static interface ChartRenderer {
        public void renderValue(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void renderMarker(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }

    public static interface Series {
        public int getTop();

        public int getBottom();

        public int getLength();

        public int getValue(int var1);
    }
}

