/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.net.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import nl.ctrlaltdev.net.server.Log;

public class HTTPSocketHandler
implements Runnable {
    private Socket mySocket;
    protected Log myLog;
    private String myRequest;
    private Map myHeaderData;
    private StringBuffer myContent;

    public HTTPSocketHandler(Socket s, Log l) {
        this.mySocket = s;
        this.myLog = l;
        this.myHeaderData = new HashMap();
        this.myContent = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.mySocket.getInputStream()));
                String s = null;
                int cnt = 0;
                do {
                    if ((s = in.readLine()) == null) continue;
                    if (cnt == 0) {
                        this.myRequest = s;
                    } else if (s.indexOf(58) >= 0) {
                        this.myHeaderData.put(s.substring(0, s.indexOf(58)).toLowerCase(), s.substring(s.indexOf(58) + 2));
                    }
                    ++cnt;
                } while (s != null && !s.equals(""));
                String l = this.getHeaderField("Content-length");
                if (l != null) {
                    int r;
                    int size = Integer.parseInt(l);
                    char[] buffer = new char[256];
                    for (int read = 0; read < size; read += r) {
                        r = in.read(buffer);
                        if (r == -1) {
                            throw new IOException("End of Stream ??");
                        }
                        this.myContent.append(buffer, 0, r);
                    }
                    s = null;
                }
                HTTPRequest req = new HTTPRequest(this.myRequest, this.myHeaderData, this.myContent.toString());
                HTTPResponse res = new HTTPResponse(this.mySocket.getOutputStream());
                try {
                    this.handleRequest(req, res);
                }
                catch (Exception e) {
                    this.myLog.error(e.getMessage());
                    res.setReplyCode(500);
                    res.getWriter().write(e.toString());
                    res.getWriter().newLine();
                }
                res.getWriter().flush();
            }
            catch (IOException e) {
                this.myLog.error(e.getMessage());
            }
            finally {
                this.mySocket.close();
            }
        }
        catch (IOException e) {
            this.myLog.error(e.getMessage());
        }
    }

    public String getHeaderField(String name) {
        return (String)this.myHeaderData.get(name.toLowerCase());
    }

    protected void handleRequest(HTTPRequest req, HTTPResponse res) throws IOException {
        res.getWriter().write("Hallo Wereld");
        res.getWriter().newLine();
    }

    public static class HTTPResponse {
        private BufferedWriter myOutput;
        private int myContentLength;
        private int myReplyCode;
        private String myContentType;
        private boolean headerSent;

        public HTTPResponse(OutputStream out) {
            this.myOutput = new BufferedWriter(new OutputStreamWriter(out));
            this.myReplyCode = 200;
            this.myContentLength = -1;
            this.myContentType = "text/html";
        }

        public void setReplyCode(int code) {
            this.myReplyCode = code;
        }

        public void setContentType(String contentType) {
            this.myContentType = contentType;
        }

        public void setContentLength(int len) {
            this.myContentLength = len;
        }

        public BufferedWriter getWriter() throws IOException {
            if (!this.headerSent) {
                if (this.myReplyCode == 200) {
                    this.myOutput.write("HTTP/1.0 200 OK");
                } else {
                    this.myOutput.write("HTTP/1.0 " + this.myReplyCode + " ERR");
                }
                this.myOutput.newLine();
                this.myOutput.write("Content-type: " + this.myContentType);
                this.myOutput.newLine();
                if (this.myContentLength > 0) {
                    this.myOutput.write("Content-length: " + this.myContentLength);
                }
                this.myOutput.newLine();
                this.myOutput.newLine();
                this.myOutput.flush();
                this.headerSent = true;
            }
            return this.myOutput;
        }
    }

    public static class HTTPRequest {
        private String myRequest;
        private String myContent;
        private Map myHeader;

        public HTTPRequest(String req, Map header, String content) {
            this.myRequest = req;
            this.myHeader = header;
            this.myContent = content;
        }

        public String getRequest() {
            return this.myRequest;
        }

        public String getContent() {
            return this.myContent;
        }

        public String getHeaderValue(String name) {
            return (String)this.myHeader.get(name.toLowerCase());
        }

        public String[] getHeaderNames() {
            return this.myHeader.keySet().toArray(new String[this.myHeader.size()]);
        }
    }
}

