/*
 * Decompiled with CFR 0.152.
 */
package nl.ctrlaltdev.ioc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationBuilder {
    private Map interfaceRegistry = new HashMap();
    private Map typeRegistry = new HashMap();
    private Map nameRegistry = new HashMap();
    private Configuration myCFG;
    private ApplicationBuilder myParent;
    private ConstructorSorter myConstructorSorter = new ConstructorSorter();
    private List log = new ArrayList();

    public ApplicationBuilder() {
        this.myCFG = new DummyConfiguration();
        this.myParent = null;
    }

    public ApplicationBuilder(Configuration cfg) {
        this.myCFG = cfg;
        this.myParent = null;
    }

    public ApplicationBuilder(ApplicationBuilder parent) {
        this();
        this.myParent = parent;
    }

    public ApplicationBuilder(ApplicationBuilder parent, Configuration cfg) {
        this(cfg);
        this.myParent = parent;
    }

    public Object get(Class type) {
        Object result = null;
        result = type.isInterface() ? this.interfaceRegistry.get(type) : this.typeRegistry.get(type);
        if (result != null) {
            return result;
        }
        return this.myParent == null ? null : this.myParent.get(type);
    }

    public Object get(String name) {
        Object result = null;
        result = this.nameRegistry.get(name);
        if (result != null) {
            return result;
        }
        return this.myParent == null ? null : this.myParent.get(name);
    }

    public void register(Class type, Object instance) {
        if (type.isInterface()) {
            this.interfaceRegistry.put(type, instance);
        } else {
            this.typeRegistry.put(type, instance);
        }
    }

    public void register(Object instance) {
        if (instance == null) {
            throw new NullPointerException("Cannot register a NULL type.");
        }
        Class[] types = this.getInterfaces(new Class[]{instance.getClass()});
        for (int t = 0; t < types.length; ++t) {
            this.register(types[t], instance);
        }
        this.register(instance.getClass(), instance);
    }

    protected Class[] getInterfaces(Class[] types) {
        ArrayList all = new ArrayList();
        for (int t = 0; t < types.length; ++t) {
            Class<?>[] interfaces = types[t].getInterfaces();
            for (int y = 0; y < interfaces.length; ++y) {
                if (!this.myCFG.isInterfaceExposedBy(types[t], interfaces[y])) continue;
                all.add(interfaces[y]);
            }
        }
        return all.toArray(new Class[all.size()]);
    }

    protected Constructor[] getApplicableConstructors(Class type) throws BuildException {
        Constructor[] con = type.getConstructors();
        if (con.length == 1) {
            return con;
        }
        ArrayList<Constructor> tmp = new ArrayList<Constructor>();
        for (int t = 0; t < con.length; ++t) {
            if (!Modifier.isPublic(con[t].getModifiers()) || !this.myCFG.isApplicableConstructor(type, con[t])) continue;
            tmp.add(con[t]);
        }
        Collections.sort(tmp, this.myConstructorSorter);
        if (tmp.size() == 0) {
            new BuildException(type.getName() + " has no applicable constructors.");
        }
        return tmp.toArray(new Constructor[tmp.size()]);
    }

    public void build(Class[] types) throws BuildException {
        String[] tmp = new String[types.length];
        this.build(tmp, types);
    }

    public void build(Map namedTypes) throws BuildException {
        this.build(namedTypes.keySet().toArray(new String[namedTypes.size()]), namedTypes.values().toArray(new Class[namedTypes.size()]));
    }

    public void build(String[] names, Class[] types) throws BuildException {
        this.log.clear();
        if (names.length != types.length) {
            throw new BuildException("Length of names and types do not match.");
        }
        if (names == null) {
            throw new NullPointerException("Cannot build with a NULL names array.");
        }
        if (types == null) {
            throw new NullPointerException("Cannot build with a NULL types array.");
        }
        int maxConstructorDepth = 0;
        for (int t = 0; t < types.length; ++t) {
            if (types[t] == null) {
                throw new NullPointerException("Cannot build with a NULL type.");
            }
            int nr = this.getApplicableConstructors(types[t]).length;
            if (nr <= maxConstructorDepth) continue;
            maxConstructorDepth = nr;
        }
        boolean doneOne = false;
        boolean complete = false;
        int currentDepth = 0;
        while (!complete) {
            complete = true;
            doneOne = false;
            for (int t = 0; t < types.length; ++t) {
                Object tmp = this.nameRegistry.get(names[t]);
                if (tmp == null) {
                    tmp = this.typeRegistry.get(types[t]);
                }
                if (tmp == null) {
                    tmp = this.interfaceRegistry.get(types[t]);
                }
                if (tmp != null) continue;
                complete = false;
                Constructor[] appCon = this.getApplicableConstructors(types[t]);
                if (currentDepth >= appCon.length) continue;
                Constructor c = appCon[currentDepth];
                Class<?>[] deps = c.getParameterTypes();
                Object[] imps = new Object[deps.length];
                boolean foundAll = true;
                for (int z = 0; z < deps.length; ++z) {
                    String name = this.myCFG.getNameForConstructorArgument(types[t], z, deps[z]);
                    imps[z] = name != null ? this.get(name) : this.get(deps[z]);
                    if (imps[z] != null) continue;
                    this.log.add("Unable to construct " + types[t].getName() + " : missing parameter instance of type " + deps[z].getName());
                    foundAll = false;
                }
                if (!foundAll) continue;
                Object instance = null;
                try {
                    instance = c.newInstance(imps);
                }
                catch (InvocationTargetException x) {
                    throw new BuildException("Unable to instantiate " + types[t].getName(), x.getTargetException());
                }
                catch (InstantiationException x) {
                    throw new BuildException("Unable to instantiate " + types[t].getName(), x);
                }
                catch (IllegalAccessException x) {
                    throw new BuildException("Unable to instantiate " + types[t].getName(), x);
                }
                this.log.add("Successfully instantiated " + c.getName() + " to " + instance);
                if (names[t] == null || names[t].length() == 0) {
                    Class[] ifs = this.getInterfaces(new Class[]{types[t]});
                    for (int z = 0; z < ifs.length; ++z) {
                        this.interfaceRegistry.put(ifs[z], instance);
                        this.log.add("Registered " + instance + " to interface " + ifs[z].getName());
                    }
                    this.typeRegistry.put(types[t], instance);
                    this.log.add("Registered " + instance + " to class " + types[t].getName());
                } else {
                    this.nameRegistry.put(names[t], instance);
                    this.log.add("Registered " + instance + " to name " + names[t]);
                }
                doneOne = true;
                currentDepth = 0;
            }
            if (!doneOne && !complete && currentDepth == maxConstructorDepth) {
                throw new BuildException("Unable to construct application.\n" + this.getLogLines());
            }
            if (doneOne) continue;
            ++currentDepth;
        }
        this.log.add("Done.");
    }

    public String getLogLines() {
        StringBuffer sb = new StringBuffer();
        String[] tmp = this.log.toArray(new String[this.log.size()]);
        for (int t = 0; t < tmp.length; ++t) {
            sb.append(tmp[t]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class ConstructorSorter
    implements Comparator {
        private ConstructorSorter() {
        }

        public int compare(Object o1, Object o2) {
            Constructor c1 = (Constructor)o1;
            Constructor c2 = (Constructor)o2;
            return c2.getParameterTypes().length - c1.getParameterTypes().length;
        }
    }

    public static class BuildException
    extends Exception {
        public BuildException(String msg) {
            super(msg);
        }

        public BuildException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class DummyConfiguration
    implements Configuration {
        @Override
        public boolean isApplicableConstructor(Class aType, Constructor c) {
            return true;
        }

        @Override
        public String getNameForConstructorArgument(Class theType, int nr, Class aType) {
            return null;
        }

        @Override
        public boolean isInterfaceExposedBy(Class aType, Class anInterface) {
            return true;
        }
    }

    public static interface Configuration {
        public boolean isApplicableConstructor(Class var1, Constructor var2);

        public boolean isInterfaceExposedBy(Class var1, Class var2);

        public String getNameForConstructorArgument(Class var1, int var2, Class var3);
    }
}

