package nl.moj.test.junit.codecompl;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import nl.moj.client.codecompletion.CodeNode;
import nl.moj.client.codecompletion.CodeNodeFactory;
import nl.moj.client.codecompletion.TypeCodeCompletion;

public class TestTypeCodeCompletion extends TestCase {

    private static enum TestEnum {
        ONE,TWO,THREE,FOUR,FIVE;
    }
    
    public void testInterface() {
        CodeNodeFactory cnf=new CodeNodeFactory();
        CodeNode root=cnf.createRoot();
        TypeCodeCompletion tcc=new TypeCodeCompletion(List.class);
        tcc.addToCodeTree(cnf,root);
        //
        assertTrue(root.containsPath("java.util.List"));
        assertTrue(root.containsPath("java.util.List.size"));
        assertTrue(root.containsPath("java.util.List.get"));
    }
    
    public void testClass() {
        CodeNodeFactory cnf=new CodeNodeFactory();
        CodeNode root=cnf.createRoot();
        TypeCodeCompletion tcc=new TypeCodeCompletion(ArrayList.class);
        tcc.addToCodeTree(cnf,root);
        //
        assertTrue(root.containsPath("java.util.List"));
        assertTrue(root.containsPath("java.util.ArrayList"));
        assertTrue(root.containsPath("java.util.ArrayList.size"));
        assertTrue(root.containsPath("java.util.ArrayList.get"));
        //
    }
    
    public void testEnum() {
        CodeNodeFactory cnf=new CodeNodeFactory();
        CodeNode root=cnf.createRoot();
        TypeCodeCompletion tcc=new TypeCodeCompletion(TestEnum.class);
        tcc.addToCodeTree(cnf,root);
        //
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.ONE"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.TWO"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.THREE"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.FOUR"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.FIVE"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.values"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.valueOf"));
        assertTrue(root.containsPath("nl.moj.test.junit.codecompl.TestTypeCodeCompletion.TestEnum.ordinal"));
        //
    }
    
}
