package nl.moj.test.junit.codecompl;

import java.util.Arrays;
import java.util.List;

import nl.moj.client.codecompletion.CodeCompletion;
import nl.moj.client.codecompletion.CodeNode;
import nl.moj.client.codecompletion.CodeNodeFactory;
import nl.moj.client.codecompletion.PartialCode;
import nl.moj.client.codecompletion.SourceCodeCompletion;
import junit.framework.TestCase;

public class TestSourceCodeCompletion extends TestCase {

    private static final String SOURCE = "package nl.bla;" + "import java.util.List;" + "import java.util.ArrayList;" + "import java.util.Map;"
            + "import java.util.HashMap;" + "public class Wodka implements List {" + " public static final String RATATA=\"RATATA\";"
            + " public List<String> blarp=new ArrayList<String>();" + " public Map<String,Object> warp=new HashMap<String,Object>();"
            + " public void getBanana() {" + "  List myBanana=new ArrayList(); " + "  for (int t=0;t<10;t++) {" + "     myBanana.add(new Integer(t));" + "  }"
            + "  return myBanana;" + " } " + " /* dfksfpoks */" + " public interface Visitor extends Comparable {" + "  public void begin(Object o);"
            + "  public void end(Object o);" + " }" + "}";

    public void testSource() {
        CodeNodeFactory cnf = new CodeNodeFactory();
        CodeNode root = cnf.createRoot();
        SourceCodeCompletion tcc = new SourceCodeCompletion(SOURCE);
        tcc.addToCodeTree(cnf, root);
        // System.out.println(root.render());
        assertTrue(root.containsPath("nl.bla.Wodka"));
        assertTrue(root.containsPath("nl.bla.Wodka.RATATA"));
        assertTrue(root.containsPath("nl.bla.Wodka.blarp"));
        assertTrue(root.containsPath("nl.bla.Wodka.warp"));
        assertTrue(root.containsPath("nl.bla.Wodka.getBanana"));
        assertTrue(root.containsPath("nl.bla.Wodka.equals")); // Test Superclass.
        assertTrue(root.containsPath("nl.bla.Wodka.Visitor"));
        assertTrue(root.containsPath("nl.bla.Wodka.Visitor.begin"));
        assertTrue(root.containsPath("nl.bla.Wodka.Visitor.end"));
        assertTrue(root.containsPath("nl.bla.Wodka.Visitor.compareTo")); // Test Interfaces
        assertFalse(root.containsPath("nl.bla.Wodka.gazazazaa"));
        assertFalse(root.containsPath("nl.bla.Nasi"));
        assertFalse(root.containsPath("n1.bla.Wodka"));
        //
        // Super class
        //
        assertTrue(root.containsPath("java.lang.Object"));
        assertTrue(root.containsPath("java.lang.Object.equals"));
        //
        // Imports
        //
        assertTrue(root.containsPath("java.util.List"));
        assertTrue(root.containsPath("java.util.List.size"));
        assertTrue(root.containsPath("java.util.List.get"));
        assertTrue(root.containsPath("java.util.ArrayList"));
        assertTrue(root.containsPath("java.util.ArrayList.size"));
        assertTrue(root.containsPath("java.util.ArrayList.get"));
        assertFalse(root.containsPath("java.util.ArrayList.zawppa"));
    }

    private static final String VARS = "class Test { Integer a; Thread b; public void do(StringBuffer c,Class d) {";
    private static final String ENDVARS = " } }";

    public void testClassFieldCompletion() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("b.is");
        List<String> c = Arrays.asList(cc.getCompletions(VARS + ENDVARS, VARS.length(), pc));
        assertTrue(c.contains("b.isAlive"));
        assertTrue(c.contains("b.isDaemon"));
        assertTrue(c.contains("b.isInterrupted"));
        assertFalse(c.contains("b.isInterface"));
    }

    public void testMethodParamCompletion() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("d.is");
        List<String> c = Arrays.asList(cc.getCompletions(VARS + ENDVARS, VARS.length(), pc));
        assertTrue(c.contains("d.isArray"));
        assertTrue(c.contains("d.isInterface"));
        assertTrue(c.contains("d.isInstance"));
        assertTrue(c.contains("d.isMemberClass"));
        assertFalse(c.contains("d.isAlive"));
        assertFalse(c.contains("d.isDeamon"));
        assertFalse(c.contains("d.isInterrupted"));
    }

    public void testMethodParamCompletionOfYetUnreferencedType() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("c.set");
        List<String> c = Arrays.asList(cc.getCompletions(VARS + ENDVARS, VARS.length(), pc));
        assertTrue(c.contains("c.setCharAt"));
        assertTrue(c.contains("c.setLength"));
        assertFalse(c.contains("c.isInstance"));
        assertFalse(c.contains("c.isMemberClass"));
        assertFalse(c.contains("c.isAlive"));
        assertFalse(c.contains("c.isDeamon"));
        assertFalse(c.contains("c.isInterrupted"));
    }

    private static final String VARS2 = "class Test { Integer a; Thread b; public void do(StringBuffer c,Class d) { Package p=null; p.";

    public void testMethodVariableCompletion() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("p.get");
        List<String> c = Arrays.asList(cc.getCompletions(VARS2 + ENDVARS, VARS2.length(), pc));
        assertTrue(c.contains("p.getAnnotation"));
        assertTrue(c.contains("p.getImplementationTitle"));
        assertFalse(c.contains("c.isMemberClass"));
        assertFalse(c.contains("c.isAlive"));
        assertFalse(c.contains("c.isDeamon"));
        assertFalse(c.contains("c.isInterrupted"));
    }

    public void testTypeCompletion() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("");
        List<String> c = Arrays.asList(cc.getCompletions(VARS + ENDVARS, VARS.length(), pc));
        System.out.println(c);
    }

}
