package nl.moj.test.junit.codecompl;

import java.util.Arrays;
import java.util.List;

import nl.moj.client.codecompletion.CodeCompletion;
import junit.framework.TestCase;

public class TestEnum extends TestCase {
	
    private static final String SIMPLEENUM="public enum TestEnum {  ONE,TWO,THREE,FOUR,FIVE; }";
    private static final String CONSTRUCTORENUM="public enum TestEnum {  ONE(1),TWO(2),THREE(3),FOUR(4),FIVE(5); public TestEnum(int i) { } }";
    private static final String METHODENUM="public enum TestEnum {  ONE(1),TWO(2),THREE(3),FOUR(4),FIVE(5); public TestEnum(int i) { } public int doIt() { } }";    
    private static final String TOCOMPLETE="public class Test { public void doTest() { ";
    private static final String PARTIALWITHENUM="public class Test { public enum TestEnum { ONE,TWO,THREE; } public void test() {";
    private static final String PARTIALEND=" } }";
    
    public void testSimpleEnum() {
        CodeCompletion cc=new CodeCompletion();
        cc.addStaticSource(SIMPLEENUM);
        List<String> r=Arrays.asList(cc.getCompletions(TOCOMPLETE,TOCOMPLETE.length(),cc.getPartToComplete("TestEnum.")));
        System.out.println(r);
        assertFalse(r.contains("TestEnum.TestEnum"));
        assertTrue(r.contains("TestEnum.values"));
        assertTrue(r.contains("TestEnum.ONE"));
        assertTrue(r.contains("TestEnum.TWO"));
        assertTrue(r.contains("TestEnum.THREE"));
        assertTrue(r.contains("TestEnum.FOUR"));
        assertTrue(r.contains("TestEnum.FIVE"));
    }
    
    public void testConstructorEnum() {
        CodeCompletion cc=new CodeCompletion();
        cc.addStaticSource(CONSTRUCTORENUM);
        List<String> r=Arrays.asList(cc.getCompletions(TOCOMPLETE,TOCOMPLETE.length(),cc.getPartToComplete("TestEnum.")));
        assertFalse(r.contains("TestEnum.TestEnum"));
        assertTrue(r.contains("TestEnum.values"));
        assertTrue(r.contains("TestEnum.ONE"));
        assertTrue(r.contains("TestEnum.TWO"));
        assertTrue(r.contains("TestEnum.THREE"));
        assertTrue(r.contains("TestEnum.FOUR"));
        assertTrue(r.contains("TestEnum.FIVE"));
    }

    public void testMethodEnum() {
        CodeCompletion cc=new CodeCompletion();
        cc.addStaticSource(METHODENUM);
        List<String> r=Arrays.asList(cc.getCompletions(TOCOMPLETE,TOCOMPLETE.length(),cc.getPartToComplete("TestEnum.")));
        assertFalse(r.contains("TestEnum"));
        assertFalse(r.contains("TestEnum.doIt"));
        assertFalse(r.contains("TestEnum.TestEnum"));
        assertTrue(r.contains("TestEnum.values"));
        assertTrue(r.contains("TestEnum.ONE"));
        assertTrue(r.contains("TestEnum.TWO"));
        assertTrue(r.contains("TestEnum.THREE"));
        assertTrue(r.contains("TestEnum.FOUR"));
        assertTrue(r.contains("TestEnum.FIVE"));
    }
    
    public void testMethodEnumToo() {
        CodeCompletion cc=new CodeCompletion();
        cc.addStaticSource(METHODENUM);
        List<String> r=Arrays.asList(cc.getCompletions(TOCOMPLETE,TOCOMPLETE.length(),cc.getPartToComplete("TestEnum.ONE.")));
        assertFalse(r.contains("TestEnum"));
        assertFalse(r.contains("TestEnum.doIt"));
        assertTrue(r.contains("TestEnum.ONE.doIt"));        
    }
    
    public void testPartialSource() {
        String complete="TestEnum.ONE.";
        CodeCompletion cc=new CodeCompletion();
        List<String> r=Arrays.asList(cc.getCompletions(PARTIALWITHENUM+complete+PARTIALEND,PARTIALWITHENUM.length()+complete.length(),cc.getPartToComplete(complete)));
        assertFalse(r.contains("TestEnum.ONE.Annotation"));
        assertTrue(r.contains("TestEnum.ONE.compareTo"));
        assertTrue(r.contains("TestEnum.ONE.equals"));
    }

}
