package nl.moj.test.junit.codecompl;

import java.util.Arrays;
import java.util.List;

import nl.moj.client.codecompletion.CodeCompletion;
import nl.moj.client.codecompletion.PartialCode;
import junit.framework.TestCase;

public class TestCombinedCompletion extends TestCase {

	public static final String BASE=
		"import java.util.concurrent.locks.Lock;"+
		"public abstract class Test {"+
		" public abstract Lock getLock();"+
		" public void doSomething() { ";
		
	public static final String END=" } }";
	
	public void testRemoveBrackets() {
		CodeCompletion cc = new CodeCompletion();
		assertEquals("",cc.removeCorresponding("()","(",")"));
		assertEquals("",cc.removeCorresponding("(())","(",")"));
		assertEquals("",cc.removeCorresponding("(()())","(",")"));
		assertEquals("(",cc.removeCorresponding("(","(",")"));
		assertEquals("getLock.try",cc.removeCorresponding("getLock().try","(",")"));
		assertEquals("doIt.",cc.removeCorresponding("doIt(isOk()).","(",")"));
	}
	
	public void testCombined() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("getLock().try");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("getLock.tryLock"));		
	}
	
	public void testRoots() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("doSomething"));		        
        assertTrue(c.contains("equals"));		        
        assertTrue(c.contains("getLock"));
        assertFalse(c.contains("Object"));
	}
}
