package nl.moj.test.junit.codecompl;

import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;

import nl.moj.client.codecompletion.CodeCompletion;
import nl.moj.client.codecompletion.PartialCode;

public class TestArrays extends TestCase {

	public static String BASE=
		"public class Test { "+
		" String[] field=new String[512];"+
		" public String[] zawappie() { return field; }"+
		" public void doIt(String[] args) {"+
		"  String[] vars=new String[512]; ";
	
	public static String SPACE_BASE=
		"public class Test { "+
		" String [] field=new String [512];"+
		" public String [] zawappie() { return field; }"+
		" public void doIt(String[] args) {"+
		"  String [] vars=new String [512]; ";	
	
	public static String END=" } }";
	
	public void testVariableArrayLength() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("vars.");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("vars.length"));
        assertFalse(c.contains("vars.indexOf"));
	}

	public void testVariableArrayLengthSpace() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("vars.");
        List<String> c = Arrays.asList(cc.getCompletions(SPACE_BASE + END, BASE.length(), pc));
        assertTrue(c.contains("vars.length"));
        assertFalse(c.contains("vars.indexOf"));
	}

	public void testVariableArrayType() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("vars[255].");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("vars.indexOf"));
	}
	
	public void testArgArrayLength() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("args.");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("args.length"));
        assertFalse(c.contains("args.indexOf"));
	}
	public void testArgArrayLengthSpace() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("args.");
        List<String> c = Arrays.asList(cc.getCompletions(SPACE_BASE + END, BASE.length(), pc));
        assertTrue(c.contains("args.length"));
        assertFalse(c.contains("args.indexOf"));
	}	
	public void testArgArrayType() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("args[255].");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("args.indexOf"));
	}
	public void testFieldArrayLength() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("field.");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("field.length"));
        assertFalse(c.contains("field.indexOf"));
	}
	public void testFieldArrayLengthSpace() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("field.");
        List<String> c = Arrays.asList(cc.getCompletions(SPACE_BASE + END, BASE.length(), pc));
        assertTrue(c.contains("field.length"));
        assertFalse(c.contains("field.indexOf"));
	}	
	public void testFieldArrayType() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("field[255].");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("field.indexOf"));
	}
	public void testMethodArrayLength() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("zawappie().");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("zawappie.length"));
        assertFalse(c.contains("zawappie.indexOf"));
	}
	public void testMethodArrayLengthSpace() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("zawappie().");
        List<String> c = Arrays.asList(cc.getCompletions(SPACE_BASE + END, BASE.length(), pc));
        assertTrue(c.contains("zawappie.length"));
        assertFalse(c.contains("zawappie.indexOf"));
	}	
	public void testMethodArrayType() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("zawappie()[255].");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("zawappie.indexOf"));
	}

	public void testMethodArrayTypeExt() {
        CodeCompletion cc = new CodeCompletion();
        PartialCode pc = cc.getPartToComplete("zawappie() [255].");
        List<String> c = Arrays.asList(cc.getCompletions(BASE + END, BASE.length(), pc));
        assertTrue(c.contains("zawappie.indexOf"));
	}

	
}
