package nl.moj.test.junit;

import junit.framework.TestCase;
import nl.moj.scoreboard.ScoringRules;
import nl.moj.scoreboard.scoringrules.MoJ2005ScoringRules;
import nl.moj.scoreboard.scoringrules.MoJ2006ScoringRules;

public class ScoringRulesTest extends TestCase {

	public void testContracts() {
		checkContract(new MoJ2005ScoringRules());
		checkContract(new MoJ2006ScoringRules());
	}
	
	void checkContract(ScoringRules rules) {
		int min=0;
		int max=(int)rules.getMaxScorePerRound();
		//
		checkScores(rules,new int[] { -1,-1,-1,-1 });
		checkScores(rules,new int[] { -1,min,max });
		checkScores(rules,new int[] { -1,min,max });
		checkScores(rules,new int[] { min-1,max+1 });
		//
	}
	
	void checkScores(ScoringRules rules,int[] times) {
		double min=0.0;
		double max=rules.getMaxScorePerRound();
		//
		double[] d=rules.assignScores(times);
		assertEquals(times.length,d.length);
		//
		for (int t=0;t<d.length;t++) {
			assertTrue(d[t]>=min);
			assertTrue(d[t]<=max);
		}
	}
	
}
