package nl.moj.test.junit;

import junit.framework.Assert;
import junit.framework.TestCase;
import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.model.Assignment;
import nl.moj.security.SandboxClassLoader;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.junit.dummy.DummyAssignment;
import nl.moj.test.junit.dummy.DummyWorkspace;


public class SandboxClassloaderTest extends TestCase {

	// Create the Evil Threadgroup - all threads in this group are potentially evil and must be checked !
	public static final ThreadGroup evil=new ThreadGroup("evil");
	
	private Assignment myAssignment;
	private SandboxSecurityManager ssm;
	
	public void setUp() {
		myAssignment=new DummyAssignment();
		SimpleLogFormatter.clearLogConfig();
		ssm=new SandboxSecurityManager(evil);
		System.setSecurityManager(ssm);
		ssm.registerAssignment(myAssignment);
	}
	
	protected boolean load(String name) {
		try {
			ThreadGroup tg=ssm.getEvilThreadGroup(myAssignment);
			new SandboxClassLoader(new DummyWorkspace(null),tg,false).loadClass(name);
			return false;
		} catch (SecurityException ex) {
			return true;
		} catch (ClassNotFoundException ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public void testAWT() {
		//
		Assert.assertTrue(load("java.awt.Component"));
		Assert.assertTrue(load("java.awt.Frame"));
		Assert.assertTrue(load("java.awt.Dialog"));
		//
		Assert.assertFalse(load("java.awt.Color"));
		Assert.assertFalse(load("java.awt.Point"));
		//
	}
	
	public void testUtil() {
		//
		Assert.assertFalse(load("java.util.List"));
		Assert.assertFalse(load("java.util.Set"));
		Assert.assertFalse(load("java.util.ArrayList"));
		Assert.assertFalse(load("java.util.HashMap"));
		Assert.assertFalse(load("java.util.HashSet"));
		Assert.assertFalse(load("java.util.TreeMap"));
		Assert.assertFalse(load("java.util.TreeSet"));
		Assert.assertFalse(load("java.util.StringTokenizer"));
		//
	}
	
	public void testReflect() {
		//
		Assert.assertTrue(load("java.lang.reflect.Method"));
		Assert.assertTrue(load("java.lang.reflect.Field"));
		Assert.assertTrue(load("java.lang.reflect.Constructor"));
		Assert.assertTrue(load("java.lang.reflect.Proxy"));
		Assert.assertTrue(load("java.lang.reflect.InvocationHandler"));
		//
	}
	
	public void testLang() {
		//
		Assert.assertFalse(load("java.lang.Object"));
		Assert.assertFalse(load("java.lang.Number"));
		Assert.assertFalse(load("java.lang.String"));
		Assert.assertFalse(load("java.lang.StringBuffer"));
		Assert.assertFalse(load("java.lang.Integer"));
		Assert.assertFalse(load("java.lang.Double"));
		//
		Assert.assertFalse(load("java.lang.Thread"));
		Assert.assertFalse(load("java.lang.ThreadGroup"));
		//
	}
	
	public void testIO() {
		//
		Assert.assertFalse(load("java.io.InputStream"));
		Assert.assertFalse(load("java.io.OutputStream"));
		//
		Assert.assertFalse(load("java.io.Reader"));
		Assert.assertFalse(load("java.io.Writer"));
		//
	}
	
	public void testNet() {
		//
		Assert.assertTrue(load("java.net.Socket"));
		Assert.assertTrue(load("java.net.ServerSocket"));
		//
		Assert.assertTrue(load("java.net.MulticastSocket"));
		Assert.assertTrue(load("java.net.URL"));
		//
	}
	
	public void testJavaX() {
		//
		Assert.assertTrue(load("java.net.URL"));
		//
	}
	
}
