package nl.moj.test.junit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.moj.model.Assignment;
import nl.moj.security.FriendlySecurityDelegate;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.test.junit.dummy.DummyAssignment;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class FriendlySecurityDelegateTest extends TestCase {

	static {
		// Preload color.
		new Color(0,0,0);
	}
	
	private static class FakeClassLoader extends ClassLoader {
		
	}
	// Create the Evil Threadgroup - all threads in this group are potentially evil and must be checked !
	public static final ThreadGroup evil=new ThreadGroup("evil");
	
	private Assignment myAssignment;
	private ThreadGroup assignmentThreadGroup;
	
	public void setUp() {
		myAssignment=new DummyAssignment("a",new FriendlySecurityDelegate());
		SimpleLogFormatter.clearLogConfig();
		System.setSecurityManager(new SandboxSecurityManager(evil));
		assertTrue(System.getSecurityManager() instanceof SandboxSecurityManager);
		SandboxSecurityManager ssm=(SandboxSecurityManager)System.getSecurityManager();
		ssm.registerAssignment(myAssignment);
		assignmentThreadGroup=ssm.getEvilThreadGroup(myAssignment);
		//
	}
	
	public void testSystemExit() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					System.exit(42);
				} catch (SecurityException ex) {
					// Good !
				}				
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	public void testSocket() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new Socket("127.0.0.1",8080);
					results.add(new AssertionFailedError("Created Socket"));
				} catch (IOException ex) {
					results.add(new AssertionFailedError("Socket creation failed with "+ex));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}

	public void testServerSocket() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new ServerSocket(8080);
					results.add(new AssertionFailedError("Created Socket"));
				} catch (IOException ex) {
					results.add(new AssertionFailedError("Socket creation failed with "+ex));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}

	public void testClassLoader() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new FakeClassLoader();
					results.add(new AssertionFailedError("ClassLoader Created"));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	
	public void testWrapperConversions() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					String.valueOf(Boolean.TRUE);
					String.valueOf(1024);
					String.valueOf(5.0);
					String.valueOf('c');
					//
					Integer.parseInt("1");
					Long.parseLong("1");
					Float.parseFloat("1.0");
					Double.parseDouble("1.0");
					//
					// Allowed : Good !
					//
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("Cant convert :"+ex.getMessage()));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}	

	public void testFileXS() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new File("c:/pindakaas.txt").delete();
					results.add(new AssertionFailedError("File Delete Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Delete Failed."));
				}
				//
				try {
					FileOutputStream out=new FileOutputStream(new File("c:/pindakaas.txt"));
					try {
						out.write(32);
					} finally {
						out.close();
					}
					results.add(new AssertionFailedError("File Write Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Write Failed."));
				}
				//
				try {
					FileInputStream in=new FileInputStream(new File("c:/pindakaas.java"));
					try {
						in.read();
					} finally {
						in.close();
					}
					results.add(new AssertionFailedError(".java File Read Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Read Failed."));
				}
				//
				try {
					FileInputStream in=new FileInputStream(new File("c:/pindakaas.class"));
					try {
						in.read();
					} finally {
						in.close();
					}
					results.add(new AssertionFailedError(".class File Read Allowed."));
				} catch (SecurityException ex) {
					// Good
				} catch (Exception ex) {
					results.add(new AssertionFailedError("File Read Failed."));
				}				
				//
				try {
					FileInputStream in=new FileInputStream(new File("c:/workspace/bin/pindakaas.txt"));
					try {
						in.read();
					} finally {
						in.close();
					}			
					// Good
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("Must be allows to read from ./workspace/*/bin"));
				} catch (Exception ex) {
					// Good
				}				
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
		//
	}	
	
	public void testSetProperties() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					System.setProperty("a","B");
					results.add(new AssertionFailedError("System.setProperty succeeded."));
				} catch (SecurityException ex) {
					// Good
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}

	public void testGetProperties() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					System.getProperty("java.vendor");
					// good !
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("System.getProperty failed."));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	public void testRuntimeExec() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					Runtime.getRuntime().exec("cmd");
					results.add(new AssertionFailedError("Runtime.getRuntime().exec succeeded."));
				} catch (SecurityException ex) {
					// Good !
				} catch (IOException ex) {
					results.add(new AssertionFailedError("Exec failed."));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);
	}
	
	public void testAccessAWT() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					new Color(0,0,0);
					BufferedImage img=new BufferedImage(256,256,BufferedImage.TYPE_INT_RGB);
					Graphics g=img.getGraphics();
					try {
						g.drawLine(0,0,256,256);
					} finally {
						g.dispose();
					}
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("AWT failed."));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);		
	}
	
	public void testChangeSecurityManager() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					System.setSecurityManager(new SecurityManager());
					results.add(new AssertionFailedError("setSecurityManager worked ?!."));
				} catch (SecurityException ex) {
					// Good !
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);		
	}
	
	public void testReflection() throws Throwable {
		final List results=new ArrayList();
		Thread tst=new Thread(assignmentThreadGroup,new Runnable() {
			public void run() {
				try {
					FriendlySecurityDelegateTest.class.getConstructors();
					FriendlySecurityDelegateTest.class.getMethods();
					FriendlySecurityDelegateTest.class.getFields();
				} catch (SecurityException ex) {
					results.add(new AssertionFailedError("use of Reflection failed."));
				}
			}
		});
		//
		tst.start();
		while (tst.isAlive()) {
			Thread.sleep(100);
		}
		if (results.size()>0) throw (Throwable)results.get(0);		
	}
}
