package nl.ctrlaltdev.io.test.junit;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import nl.ctrlaltdev.io.OutputRedirector;

public class TestOutputRedirector extends TestCase {

	private static class DummyTarget implements OutputRedirector.Target {
		private Map<String,StringBuffer> out=new HashMap<String, StringBuffer>();
		@Override
		public void append(String context, String s) {
			context=String.valueOf(context);
			if (!out.containsKey(context)) {
				out.put(context,new StringBuffer());
			} 
			out.get(context).append(s);
		}	
		public boolean isContext(String ctx) {
			return out.containsKey(ctx);
		}
		public String get(String ctx) {
			StringBuffer sb=out.get(ctx);
			if (sb==null) return null;
			return sb.toString();
		}
		public String toString() {
			return out.toString();
		}
	}
	
	public void testRedirect() {
		DummyTarget target=new DummyTarget();
		OutputRedirector.getSingleton().redirect(Thread.currentThread(),target);
		try {
			System.out.print("Yahoo!");
		} finally {
			OutputRedirector.getSingleton().cancel(Thread.currentThread());
		}
		// This should appear on the console.
		System.out.println("Flappie");
		//
		assertEquals("Yahoo!",target.get("null"));
	}
	
	public void testRedirectContext() {
		DummyTarget target=new DummyTarget();
		OutputRedirector.getSingleton().redirect(Thread.currentThread(),target);
		try {
			System.out.print("Yahoo!");
			OutputRedirector.getSingleton().setContext("1");
			System.out.print("Pindakaas!");
			OutputRedirector.getSingleton().setContext("2");
			System.out.print("Wodka!");
			OutputRedirector.getSingleton().setContext("1");
			System.out.print("Sju!");
		} finally {
			OutputRedirector.getSingleton().cancel(Thread.currentThread());
		}
		//
		assertEquals("Yahoo!",target.get("null"));
		assertEquals("Pindakaas!Sju!",target.get("1"));		
		assertEquals("Wodka!",target.get("2"));
		//
	}
	
	public void testRedirectThreaded() throws Exception {
		DummyTarget target=new DummyTarget();
		OutputRedirector.getSingleton().redirect(Thread.currentThread(),target);
		try {
			System.out.print("Yahoo!");
			Thread t=new Thread(new Runnable() {
				@Override
				public void run() {
					System.out.print("WizzieWazzie!");
					OutputRedirector.getSingleton().cancel(Thread.currentThread());
					// Should appear on the console.
					System.out.print("WizzieWazzie!");
				}
			});
			OutputRedirector.getSingleton().redirectToSame(t, Thread.currentThread());
			try {
				t.start();
				while (t.isAlive()) {
					Thread.sleep(100);
				}
			} finally {
				OutputRedirector.getSingleton().cancel(t);
			}
			System.out.print("Yahoo!");
		} finally {
			OutputRedirector.getSingleton().cancel(Thread.currentThread());
		}		
		//
		assertEquals("Yahoo!WizzieWazzie!Yahoo!",target.get("null"));
		//
	}
}
