package nl.moj.test.gremlin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import nl.ctrlaltdev.util.Tool;
import nl.moj.mgmt.TeamProfileList;

/**
 * If the smart gremlin client cannot disect the source, use this.
 * @author E. Hooijmeier
 */

public class AlwaysGoodGremlinClient extends GremlinClient {

    private String sol;
    
    public AlwaysGoodGremlinClient(String name,String server,int interval,String team,String pass,String solution) throws NoSuchAlgorithmException {
        super(name,server,interval,team,pass);
        this.sol=solution;
    }
    
    @Override
    public String generateSource() {
        return sol;
    }
    
    protected static String readSolutionOutOfJar(String jarFile) throws IOException {
        //
        JarFile assignmentJar=new JarFile(new File(jarFile));
        String solution=assignmentJar.getManifest().getMainAttributes().getValue("Solution");
        if (solution==null) {
            System.out.println("Jar File '"+jarFile+"' does not contain a 'Solution' manifest entry.");
            System.exit(1);
        }
        //
        ZipEntry ze=assignmentJar.getEntry(solution);
        if (ze==null) {
            System.out.println("Jar File '"+jarFile+"' does not contain the file '"+solution+"' as indicated by the Manifest.");
            System.exit(1);
        }
        //
        String source=Tool.read(new BufferedReader(new InputStreamReader(assignmentJar.getInputStream(ze))),true);
        //
        return source;
    }
    
    public static void main(String[] args) throws Throwable {
        if (args.length!=4) {
            System.out.println("SmartGremlinClient : A LoadTesting client for the MOJ Server. ");
            System.out.println("Usage : SmartGremlinClient [server ip address] [interval] [team.properties] [assignment.jar]]");
            System.exit(1);
        }
        //
        String source=readSolutionOutOfJar(args[3]);
        //
        TeamProfileList tpl=new TeamProfileList(new File(args[2]));
        //
        for (int t=0;t<tpl.getNumberOfTeams();t++) {
            GremlinClient gc=new AlwaysGoodGremlinClient("Gremlin#"+t,args[0],Integer.parseInt(args[1]),tpl.getTeamName(t),"Welkom",source);
            new Thread(gc).start();
        }
        //      
    }
    
}
