/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.server;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nl.ctrlaltdev.net.server.Log;
import nl.moj.workspace.WorkspaceClientServer;
import nl.moj.workspace.io.Message;
import nl.moj.workspace.io.WorkspaceMessageFactory;

public class WorkspaceMessageHandler
implements Runnable {
    private Socket socket;
    private Log log;
    private DataOutputStream out;
    private DataInputStream in;
    private boolean stop;
    private WorkspaceClientServer wcs;
    private WorkspaceMessageFactory factory = new WorkspaceMessageFactory();

    public WorkspaceMessageHandler(Socket s, Log l, WorkspaceClientServer wcs) {
        try {
            this.socket = s;
            this.log = l;
            s.setSoTimeout(1000);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(s.getInputStream());
            this.stop = false;
            this.wcs = wcs;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                Message msg;
                try {
                    msg = this.factory.createMessage(this.in);
                }
                catch (SocketTimeoutException ex) {
                    msg = null;
                }
                Message[] reply = null;
                if (msg != null) {
                    switch (msg.getType()) {
                        case 0: {
                            reply = this.wcs.onAssignment((Message.Assignment)msg);
                            break;
                        }
                        case 1: {
                            reply = this.wcs.onPerform((Message.Perform)msg);
                            break;
                        }
                        case 2: {
                            reply = this.wcs.onRequestContents((Message.ContentsRequest)msg);
                            break;
                        }
                        case 6: {
                            reply = this.wcs.onGoodbye((Message.Goodbye)msg);
                            this.stop = true;
                        }
                    }
                } else {
                    reply = this.wcs.onNoOp();
                }
                if (reply == null) continue;
                for (int t = 0; t < reply.length; ++t) {
                    reply[t].write(this.out);
                }
                this.out.flush();
            } while (!this.stop);
        }
        catch (Exception ex) {
            this.log.error("Error in WorkspaceMessageHandler : " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                this.log.info("Closing connection.");
                this.socket.close();
            }
            catch (IOException ex) {
                this.log.error("Error closing Socket : " + ex.getMessage());
            }
        }
    }
}

