/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.IOException;
import nl.moj.workspace.io.AssignmentMessage;
import nl.moj.workspace.io.ConsoleMessage;
import nl.moj.workspace.io.ContentsReply;
import nl.moj.workspace.io.ContentsRequest;
import nl.moj.workspace.io.GoodbyeMessage;
import nl.moj.workspace.io.Message;
import nl.moj.workspace.io.PerformMessage;
import nl.moj.workspace.io.ProcessStateMessage;

public class WorkspaceMessageFactory {
    public Message createMessage(DataInput in) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 0: {
                return new AssignmentMessage(type, in);
            }
            case 6: {
                return new GoodbyeMessage(type, in);
            }
            case 1: {
                return new PerformMessage(type, in);
            }
            case 2: {
                return new ContentsRequest(type, in);
            }
            case 4: {
                return new ConsoleMessage(type, in);
            }
            case 5: {
                return new ProcessStateMessage(type, in);
            }
            case 3: {
                return new ContentsReply(type, in);
            }
        }
        throw new IOException("Unsupported Message type : " + type);
    }
}

