/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.model.Operation;
import nl.moj.operation.ContextImpl;
import nl.moj.workspace.io.AbstractWorkspaceMessage;
import nl.moj.workspace.io.Message;

public class PerformMessage
extends AbstractWorkspaceMessage
implements Message.Perform {
    private int myIndex;
    private String myOperationName;
    private String[] names;
    private String[] values;

    public PerformMessage(String operationName, Operation.Context ctx) {
        super(1);
        this.myOperationName = operationName;
        this.names = ctx.getNames();
        this.myIndex = ctx.getIndex();
        this.values = new String[this.names.length];
        for (int t = 0; t < this.names.length; ++t) {
            this.values[t] = ctx.getContents(this.names[t]);
        }
    }

    public PerformMessage(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 1) {
            throw new IOException("Incorrect Type");
        }
        this.myOperationName = in.readUTF();
        this.myIndex = in.readInt();
        int cnt = in.readInt();
        this.names = new String[cnt];
        this.values = new String[cnt];
        for (int t = 0; t < cnt; ++t) {
            this.names[t] = in.readUTF();
            this.values[t] = in.readUTF();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myOperationName);
        out.writeInt(this.myIndex);
        out.writeInt(this.names.length);
        for (int t = 0; t < this.names.length; ++t) {
            out.writeUTF(this.names[t]);
            out.writeUTF(this.values[t]);
        }
    }

    @Override
    public Operation.Context getContext() {
        return new ContextImpl(this.names, this.values, this.myIndex);
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public String getOperationName() {
        return this.myOperationName;
    }
}

