/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.Message;

public abstract class AbstractWorkspaceMessage
implements Message {
    private static int lastId = 0;
    private int myType;
    private int myId;
    private int mySourceId;

    private static synchronized int nextId() {
        return lastId++;
    }

    public AbstractWorkspaceMessage(int type) {
        this.myType = type;
        this.myId = AbstractWorkspaceMessage.nextId();
        this.mySourceId = -1;
    }

    public AbstractWorkspaceMessage(int type, int sourceId) {
        this.myType = type;
        this.myId = AbstractWorkspaceMessage.nextId();
        this.mySourceId = sourceId;
    }

    public AbstractWorkspaceMessage(int type, DataInput in) throws IOException {
        this.myType = type;
        this.myId = in.readInt();
        this.mySourceId = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.myType);
        out.writeInt(this.myId);
        out.writeInt(this.mySourceId);
    }

    @Override
    public int getId() {
        return this.myId;
    }

    @Override
    public int getSourceId() {
        return this.mySourceId;
    }

    @Override
    public int getType() {
        return this.myType;
    }
}

