/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.factory;

import java.io.IOException;
import java.net.Socket;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.Workspace;
import nl.moj.process.ProcessPool;
import nl.moj.workspace.LoadBalancer;
import nl.moj.workspace.RemoteWorkspaceClient;
import nl.moj.workspace.WorkspaceRetrier;
import nl.moj.workspace.factory.WorkspaceFactory;

public class RemoteWorkspaceFactory
implements WorkspaceFactory,
LoadBalancer {
    private String host;
    private int port;

    public RemoteWorkspaceFactory(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public Workspace createWorkspace(String team, OutputRedirector.Target target, ProcessPool.ProcessListener list) throws IOException {
        return new WorkspaceRetrier(new RemoteWorkspaceClient(team, this, target, list));
    }

    @Override
    public Socket getWorkspaceServerConnection(String workspaceName, boolean resume) throws IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(1000);
        return socket;
    }

    @Override
    public void reportClosing(Socket s) {
    }

    @Override
    public void reportFailure(Socket s) {
    }
}

