/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace.factory;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.State;
import nl.moj.model.Workspace;
import nl.moj.process.ProcessPool;
import nl.moj.util.InetAddressUtil;
import nl.moj.workspace.LoadBalancer;
import nl.moj.workspace.RemoteWorkspaceClient;
import nl.moj.workspace.WorkspaceRetrier;
import nl.moj.workspace.factory.WorkspaceFactory;

public class MultiRemoteWorkspaceFactory
implements WorkspaceFactory,
LoadBalancer {
    private static final Logger log = Logger.getLogger("MRWorkspaceFactory");
    private String[] hosts;
    private int[] ports;
    private int[] connections;
    private int[] failures;
    private Map sockets;
    private State.Writer stateWriter;
    private State state;

    public MultiRemoteWorkspaceFactory(String[] hosts, int[] ports, State state, State.Writer stateWriter) {
        if (hosts.length != ports.length) {
            throw new RuntimeException("# of hosts does not match # of ports.");
        }
        this.hosts = hosts;
        this.ports = ports;
        this.state = state;
        this.stateWriter = stateWriter;
        this.connections = new int[hosts.length];
        this.failures = new int[hosts.length];
        this.sockets = new HashMap();
    }

    @Override
    public Workspace createWorkspace(String team, OutputRedirector.Target target, ProcessPool.ProcessListener list) throws IOException {
        return new WorkspaceRetrier(new RemoteWorkspaceClient(team, this, target, list));
    }

    protected synchronized int selectHost(String team) {
        int max = Integer.MAX_VALUE;
        int selected = -1;
        for (int t = 0; t < this.hosts.length; ++t) {
            if (this.connections[t] + this.failures[t] >= max) continue;
            selected = t;
            max = this.connections[t] + this.failures[t];
        }
        return selected;
    }

    @Override
    public synchronized Socket getWorkspaceServerConnection(String workspaceName, boolean resume) throws IOException {
        int selected = -1;
        if (resume) {
            String host = this.state.getLastHost(workspaceName);
            int port = 0;
            if (host != null) {
                port = this.state.getLastPort(workspaceName);
                for (int t = 0; t < this.hosts.length; ++t) {
                    if (!this.hosts[t].equals(host) || this.ports[t] != port) continue;
                    selected = t;
                }
            }
            if (selected == -1) {
                log.warning("Unable to find the previous host for '" + workspaceName + "'");
            } else {
                log.info("Found previous host '" + host + ":" + port + "' for '" + workspaceName + "'");
            }
        }
        if (selected == -1) {
            selected = this.selectHost(workspaceName);
        }
        if (selected == -1) {
            throw new RuntimeException("Unable to select a Workspace Host : None available.");
        }
        Socket socket = new Socket(InetAddressUtil.makeInetAddress(this.hosts[selected]), this.ports[selected]);
        socket.setSoTimeout(1000);
        this.sockets.put(socket, new Integer(selected));
        int n = selected;
        this.connections[n] = this.connections[n] + 1;
        this.stateWriter.workspaceHost(workspaceName, this.hosts[selected], this.ports[selected]);
        return socket;
    }

    @Override
    public synchronized void reportClosing(Socket s) {
        Integer i = (Integer)this.sockets.get(s);
        if (i != null) {
            int sel;
            int n = sel = i.intValue();
            this.connections[n] = this.connections[n] - 1;
        }
        this.sockets.remove(s);
    }

    @Override
    public void reportFailure(Socket s) {
        Integer i = (Integer)this.sockets.get(s);
        if (i != null) {
            int sel;
            int n = sel = i.intValue();
            this.failures[n] = this.failures[n] + 1;
        }
    }
}

