/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.workspace;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.Assignment;
import nl.moj.model.Operation;
import nl.moj.model.Workspace;
import nl.moj.process.ProcessPool;

public class LocalWorkspace
implements Workspace.Internal,
ProcessPool.ProcessListener {
    private static final Logger log = Logger.getLogger("LocalWorkspace");
    private File projectRoot;
    private File sourceRoot;
    private File binRoot;
    private String myName;
    private Map currentState;
    private boolean isCompiled;
    private boolean textFileIsMonospaced;
    private Operation[] operations;
    private OutputRedirector.Target outputTarget;
    private ProcessPool.ProcessListener processListener;
    private Operation currentOperation;
    private String[] editableFiles = new String[0];

    public LocalWorkspace(String name, OutputRedirector.Target tm, ProcessPool.ProcessListener lst) throws IOException {
        this.myName = name;
        this.currentState = new HashMap();
        this.operations = new Operation[0];
        this.outputTarget = tm;
        this.processListener = lst;
        this.projectRoot = new File("./workspace/" + name);
        if (!this.projectRoot.exists() && !this.projectRoot.mkdirs()) {
            throw new IOException("Failed to create project root.");
        }
        this.sourceRoot = new File(this.projectRoot, "src");
        if (!this.sourceRoot.exists() && !this.sourceRoot.mkdirs()) {
            throw new IOException("Failed to create source root.");
        }
        this.binRoot = new File(this.projectRoot, "bin");
        if (!this.binRoot.exists() && !this.binRoot.mkdirs()) {
            throw new IOException("Failed to create bin root.");
        }
    }

    @Override
    public Operation[] getAllOperations() {
        return this.operations;
    }

    @Override
    public Operation getOperationByName(String name) {
        for (int t = 0; t < this.operations.length; ++t) {
            if (!this.operations[t].getName().equals(name)) continue;
            return this.operations[t];
        }
        return null;
    }

    @Override
    public synchronized void perform(Operation op, Operation.Context ctx) {
        if (this.currentOperation == null) {
            this.currentOperation = this.getOperationByName(op.getName());
            if (this.currentOperation == null) {
                throw new NullPointerException("Unsupported operation '" + op.getName() + "'");
            }
            this.currentOperation.perform(this, this, ctx);
        } else {
            this.outputTarget.append(null, "Busy.");
        }
    }

    public synchronized boolean isPerforming() {
        return this.currentOperation != null;
    }

    @Override
    public void update() throws IOException {
    }

    @Override
    public void complete(Runnable r) {
        this.currentOperation = null;
        this.processListener.complete(r);
    }

    @Override
    public void executing(Runnable r) {
        this.processListener.executing(r);
    }

    @Override
    public void queued(Runnable r) {
        this.processListener.queued(r);
    }

    @Override
    public OutputRedirector.Target getTarget() {
        return this.outputTarget;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void loadAssignment(Assignment assignment, boolean resume) throws IOException {
        FileOutputStream out;
        File f;
        InputStream in;
        int t;
        this.editableFiles = assignment.getEditableFileNames();
        this.textFileIsMonospaced = assignment.isDescriptionRenderedInMonospaceFont();
        this.operations = assignment.getOperations();
        if (!resume) {
            this.delTree(this.projectRoot);
        }
        String[] name = assignment.getDescriptionFileNames();
        for (t = 0; t < name.length; ++t) {
            in = assignment.getAssignmentFileData(name[t]);
            f = new File(this.projectRoot, name[t]);
            if (resume && f.exists()) continue;
            if (!f.exists() && !f.createNewFile()) {
                throw new IOException("Unable to create :" + f);
            }
            out = new FileOutputStream(f);
            LocalWorkspace.copyStream(in, out);
        }
        name = assignment.getSourceCodeFileNames();
        for (t = 0; t < name.length; ++t) {
            in = assignment.getAssignmentFileData(name[t]);
            f = new File(this.sourceRoot, name[t]);
            if (resume && f.exists()) continue;
            if (!f.exists() && !f.createNewFile()) {
                throw new IOException("Unable to create :" + f);
            }
            if (resume) {
                log.warning("Writing '" + f + "' - its missing");
            }
            out = new FileOutputStream(f);
            LocalWorkspace.copyStream(in, out);
        }
    }

    @Override
    public void dispose() {
        try {
            this.delTree(this.projectRoot);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to dispose of workspace files : " + ex.getMessage());
        }
    }

    @Override
    public void suspend() {
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    public File[] getProjectFiles() {
        return this.projectRoot.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory();
            }
        });
    }

    @Override
    public File getSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    public File[] getSourceFiles() {
        return this.sourceRoot.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return f.getName().endsWith(".java");
            }
        });
    }

    @Override
    public void clearBinary() throws IOException {
        this.isCompiled = false;
        this.delTree(this.binRoot);
    }

    @Override
    public File getBinaryRoot() {
        return this.binRoot;
    }

    @Override
    public String[] getEditorFiles() {
        int t;
        ArrayList<String> files = new ArrayList<String>();
        File[] f = this.getProjectFiles();
        for (t = 0; t < f.length; ++t) {
            files.add(f[t].getName());
        }
        f = this.getSourceFiles();
        for (t = 0; t < f.length; ++t) {
            files.add(f[t].getName());
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public boolean isJava(String name) {
        if (!name.endsWith(".java")) {
            return false;
        }
        File f = this.getAsFile(name);
        return f.exists();
    }

    @Override
    public boolean isMonospaced(String name) {
        if (name.endsWith(".txt")) {
            return this.textFileIsMonospaced;
        }
        return false;
    }

    @Override
    public boolean isReadOnly(String name) {
        if (!this.isJava(name)) {
            return true;
        }
        for (int t = 0; t < this.editableFiles.length; ++t) {
            if (!name.equals(this.editableFiles[t])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getContents(String name) throws IOException {
        File f = this.getAsFile(name);
        if (f == null) {
            throw new NullPointerException("Unknown file : " + name);
        }
        return LocalWorkspace.read(new BufferedReader(new FileReader(f)));
    }

    @Override
    public boolean save(String name, String contents) throws IOException {
        if (name == null) {
            throw new NullPointerException("Cannot save a NULL file.");
        }
        if (contents == null) {
            throw new NullPointerException("Cannot save NULL contents to " + name);
        }
        if (this.isReadOnly(name)) {
            throw new IOException("File is readonly.");
        }
        File f = this.getAsFile(name);
        if (f == null) {
            throw new NullPointerException("Unknown file : " + name);
        }
        String last = (String)this.currentState.get(name);
        if (last == null) {
            this.write(f, contents);
            this.currentState.put(name, contents);
            return true;
        }
        if (!last.equals(contents)) {
            this.write(f, contents);
            this.currentState.put(name, contents);
            return true;
        }
        return false;
    }

    protected File getAsFile(String file) {
        int t;
        File[] f = this.getSourceFiles();
        for (t = 0; t < f.length; ++t) {
            if (!f[t].getName().equals(file)) continue;
            return f[t];
        }
        f = this.getProjectFiles();
        for (t = 0; t < f.length; ++t) {
            if (!f[t].getName().equals(file)) continue;
            return f[t];
        }
        return null;
    }

    private void delTree(File f) throws IOException {
        if (f.getName().startsWith(".")) {
            return;
        }
        if (f.isDirectory()) {
            File[] ff = f.listFiles();
            for (int t = 0; t < ff.length; ++t) {
                this.delTree(ff[t]);
            }
        }
        if (f.isDirectory()) {
            return;
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete " + f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int rd;
            byte[] buffer = new byte[8192];
            do {
                if ((rd = in.read(buffer, 0, buffer.length)) <= 0) continue;
                out.write(buffer, 0, rd);
            } while (rd >= 0);
        }
        finally {
            out.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(BufferedReader in) throws IOException {
        StringBuffer result = new StringBuffer();
        try {
            String s = in.readLine();
            while (s != null) {
                int idx = -1;
                while ((idx = s.indexOf(9)) >= 0) {
                    s = s.substring(0, idx) + "    " + s.substring(idx + 1);
                }
                result.append(s);
                result.append("\n");
                s = in.readLine();
            }
        }
        finally {
            in.close();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File f, String data) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(f));
        this.isCompiled = false;
        try {
            out.write(data);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    public void markCompiled() {
        this.isCompiled = true;
    }
}

