/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test.gremlin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.SourceCodeParser;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.StatementVisitor;
import nl.moj.mgmt.TeamProfileList;
import nl.moj.test.gremlin.GremlinClient;

public class SmartGremlinClient
extends GremlinClient {
    private CodeSegment[] segments;

    public SmartGremlinClient(String name, String server, int interval, String team, String pass, CodeSegment[] codeSegments) throws NoSuchAlgorithmException {
        super(name, server, interval, team, pass);
        this.segments = codeSegments;
        if (this.segments.length <= 2) {
            throw new RuntimeException("2 or less code segments to choose from.");
        }
        int mnd = 0;
        for (int t = 0; t < this.segments.length; ++t) {
            if (!this.segments[t].isMandatory()) continue;
            ++mnd;
        }
    }

    @Override
    public String generateSource() {
        StringBuffer sb = new StringBuffer();
        int cnt = 0;
        for (int t = 0; t < this.segments.length; ++t) {
            if (this.segments[t].isMandatory()) {
                sb.append(this.segments[t].getCode());
                ++cnt;
                continue;
            }
            if (!(Math.random() > 0.25)) continue;
            sb.append(this.segments[t].getCode());
            ++cnt;
        }
        System.out.println("Generated source using " + cnt + " out of " + this.segments.length + " code segments.");
        return sb.toString();
    }

    public static List dissectSource(String source) {
        final ArrayList codeSegments = new ArrayList();
        SourceCodeParser parser = new SourceCodeParser(source, false);
        parser.visit(new StatementVisitor(){
            StringBuffer current = new StringBuffer();

            @Override
            public void begin() {
            }

            @Override
            public void beginStatement(AbstractStatement st, int indent, boolean isLast) {
                for (int t = 0; t < indent; ++t) {
                    this.current.append(" ");
                }
                this.current.append(st.getStatement());
                this.current.append("{");
                this.current.append("\n");
            }

            @Override
            public void onStatement(AbstractStatement st, int indent, boolean isLast) {
                this.endSegment(true);
                for (int t = 0; t < indent; ++t) {
                    this.current.append(" ");
                }
                this.current.append(st.getStatement());
                this.current.append(";");
                this.current.append("\n");
                if (st.getParent().isMethodStatement() && !st.isVariableDeclarationStatement() && !st.isReturnStatement() || st.isIfStatement()) {
                    this.endSegment(false);
                }
            }

            @Override
            public void endStatement(AbstractStatement st, int indent, boolean isLast) {
                for (int t = 0; t < indent; ++t) {
                    this.current.append(" ");
                }
                this.current.append("}\n");
            }

            @Override
            public void end() {
                this.endSegment(true);
            }

            public void endSegment(boolean mandatory) {
                if (this.current.length() == 0) {
                    return;
                }
                CodeSegment cs = new CodeSegment(this.current.toString(), mandatory);
                codeSegments.add(cs);
                this.current.delete(0, this.current.length() - 1);
            }
        });
        return codeSegments;
    }

    protected static String readSolutionOutOfJar(String jarFile) throws IOException {
        ZipEntry ze;
        JarFile assignmentJar = new JarFile(new File(jarFile));
        String solution = assignmentJar.getManifest().getMainAttributes().getValue("Solution");
        if (solution == null) {
            System.out.println("Jar File '" + jarFile + "' does not contain a 'Solution' manifest entry.");
            System.exit(1);
        }
        if ((ze = assignmentJar.getEntry(solution)) == null) {
            System.out.println("Jar File '" + jarFile + "' does not contain the file '" + solution + "' as indicated by the Manifest.");
            System.exit(1);
        }
        String source = Tool.read(new BufferedReader(new InputStreamReader(assignmentJar.getInputStream(ze))), true);
        return source;
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 4) {
            System.out.println("SmartGremlinClient : A LoadTesting client for the MOJ Server. ");
            System.out.println("Usage : SmartGremlinClient [server ip address] [interval] [team.properties] [assignment.jar]]");
            System.exit(1);
        }
        String source = SmartGremlinClient.readSolutionOutOfJar(args[3]);
        List codeSegments = SmartGremlinClient.dissectSource(source);
        TeamProfileList tpl = new TeamProfileList(new File(args[2]));
        for (int t = 0; t < tpl.getNumberOfTeams(); ++t) {
            SmartGremlinClient gc = new SmartGremlinClient("Gremlin#" + t, args[0], Integer.parseInt(args[1]), tpl.getTeamName(t), "Welkom", codeSegments.toArray(new CodeSegment[codeSegments.size()]));
            new Thread(gc).start();
        }
    }

    private static final class CodeSegment {
        private String code;
        private boolean mandatory;

        public CodeSegment(String code, boolean mandatory) {
            this.code = code;
            this.mandatory = mandatory;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.mandatory + " '" + this.code + "'";
        }
    }
}

