/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nl.moj.model.Workspace;

public class WorkspaceClassloader
extends ClassLoader {
    private Workspace.Internal myWorkspace;
    private boolean reverse;

    public WorkspaceClassloader(Workspace.Internal w, boolean reverse) {
        this.myWorkspace = w;
        this.reverse = reverse;
    }

    public WorkspaceClassloader(Workspace.Internal j, ClassLoader parent, boolean reverse) {
        super(parent);
        this.myWorkspace = j;
        this.reverse = reverse;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        this.checkPermissionToLoad(name);
        return super.loadClass(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.checkPermissionToLoad(name);
        if (this.reverse) {
            return this.reverseOrderLoadClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        try {
            String file = name.replace('.', '/') + ".class";
            File target = new File(this.myWorkspace.getBinaryRoot(), file);
            if (!target.exists()) {
                throw new ClassNotFoundException(name);
            }
            byte[] b = this.loadClassData(target);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        byte[] data = new byte[(int)f.length()];
        try {
            int cnt;
            int pos = 0;
            do {
                if ((cnt = ((InputStream)in).read(data, pos, data.length - pos)) >= 0) continue;
                throw new IOException("Not enough bytes.");
            } while ((pos += cnt) < data.length);
        }
        finally {
            ((InputStream)in).close();
        }
        return data;
    }

    public void checkPermissionToLoad(String name) {
    }

    protected synchronized Class reverseOrderLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            if (name.indexOf(46) < 0) {
                c = this.findClass(name);
            } else {
                try {
                    c = super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException e) {
                    c = this.findClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

