/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends ClassLoader {
    private JarFile myJar;

    public JarClassLoader(JarFile j) {
        this.myJar = j;
    }

    public JarClassLoader(JarFile j, ClassLoader parent) {
        super(parent);
        this.myJar = j;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        this.checkPermissionToLoad(name);
        return super.loadClass(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.checkPermissionToLoad(name);
        return super.loadClass(name, resolve);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        try {
            JarEntry e = this.findJarEntry(name);
            if (e == null) {
                throw new ClassNotFoundException(name);
            }
            byte[] b = this.loadClassData(e);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(name);
        }
    }

    private JarEntry findJarEntry(String name) {
        name = name.replace('.', '/') + ".class";
        return (JarEntry)this.myJar.getEntry(name);
    }

    private byte[] loadClassData(JarEntry e) throws IOException {
        int cnt;
        InputStream in = this.myJar.getInputStream(e);
        byte[] data = new byte[(int)e.getSize()];
        int pos = 0;
        do {
            if ((cnt = in.read(data, pos, data.length - pos)) >= 0) continue;
            throw new IOException("Not enough bytes.");
        } while ((pos += cnt) < data.length);
        return data;
    }

    public void checkPermissionToLoad(String name) {
    }
}

