/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.server.socket;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nl.ctrlaltdev.net.server.Log;
import nl.moj.client.io.Message;
import nl.moj.client.io.MessageFactory;
import nl.moj.model.Scheduler;
import nl.moj.server.ClientServerImpl;
import nl.moj.server.ClientServerInterface;

public class SocketMessageHandler
implements Runnable {
    private MessageFactory factory = new MessageFactory();
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private Log log;
    private boolean stop;
    private ClientServerInterface csi;

    public SocketMessageHandler(Socket s, Log l, Scheduler scheduler) {
        try {
            this.socket = s;
            this.log = l;
            this.csi = new ClientServerImpl(scheduler);
            s.setSoTimeout(1000);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(s.getInputStream());
            this.stop = false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                Message msg;
                this.csi.update();
                try {
                    msg = this.factory.createMessage(this.in);
                }
                catch (SocketTimeoutException ex) {
                    msg = null;
                }
                Message[] reply = null;
                if (msg != null) {
                    switch (msg.getType()) {
                        case 0: {
                            reply = this.csi.onHello((Message.Hello)msg);
                            break;
                        }
                        case 12: {
                            reply = this.csi.onGoodBye((Message.GoodBye)msg);
                            this.stop = true;
                            break;
                        }
                        case 3: {
                            reply = this.csi.onAction((Message.Action)msg);
                        }
                    }
                } else if (!this.csi.isInitial()) {
                    reply = this.csi.onNoOp(null);
                } else {
                    this.stop = true;
                }
                if (reply == null) continue;
                for (int t = 0; t < reply.length; ++t) {
                    reply[t].write(this.out);
                }
                this.out.flush();
            } while (!this.stop);
        }
        catch (ClientServerInterface.InvalidStateException ex) {
            this.log.error("StateException in MessageHandler : " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.log.error("Error in MessageHandler : " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (!this.csi.isInitial()) {
                    try {
                        this.csi.onGoodBye(null);
                    }
                    catch (ClientServerInterface.InvalidStateException ex) {}
                }
                this.log.info("Closing connection.");
                this.socket.close();
            }
            catch (IOException ex) {
                this.log.error("Error closing Socket : " + ex.getMessage());
            }
        }
    }
}

