/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.security;

import java.io.FilePermission;
import java.security.Permission;
import java.util.PropertyPermission;
import java.util.logging.Level;
import nl.moj.model.Tester;
import nl.moj.security.AbstractSecurityDelegate;

public class DefaultSecurityDelegate
extends AbstractSecurityDelegate
implements Tester.SecurityDelegate {
    @Override
    protected void setIllegalClasses() {
        this.addIllegalClass("java.lang.reflect.*");
        this.addIllegalClass("java.sql.*");
        this.addIllegalClass("java.awt.*");
        this.addIllegalClass("java.rmi.*");
        this.addIllegalClass("java.net.*");
        this.addIllegalClass("java.nio.*");
        this.addIllegalClass("javax.*");
        this.addIllegalClass("com.*");
        this.addIllegalClass("org.*");
    }

    @Override
    protected void setAllowedClasses() {
        this.addAllowedClass("java.awt.Color");
        this.addAllowedClass("java.awt.Point");
    }

    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        if (perm instanceof PropertyPermission) {
            PropertyPermission pp = (PropertyPermission)perm;
            if (pp.getActions().indexOf("write") < 0) {
                return;
            }
        } else if (perm instanceof FilePermission) {
            FilePermission fp = (FilePermission)perm;
            if (fp.getActions().equals("read") && fp.getName().indexOf("workspace") >= 0 && fp.getName().indexOf("bin") >= 0) {
                return;
            }
        } else if (perm instanceof RuntimePermission) {
            RuntimePermission rp = (RuntimePermission)perm;
            if ("accessClassInPackage.sun.text.resources".equals(rp.getName())) {
                return;
            }
            if ("accessClassInPackage.sun.awt.resources".equals(rp.getName())) {
                return;
            }
            if ("loadLibrary.awt".equals(rp.getName())) {
                return;
            }
        }
        log.log(Level.SEVERE, Thread.currentThread().getName() + " : Permission Denied : " + perm);
        throw new SecurityException("Permission Denied : " + perm);
    }
}

