/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scoreboard.scoringrules;

import nl.moj.scoreboard.ScoringRules;

public class MoJ2005ScoringRules
implements ScoringRules {
    private static final double[] SCORES = new double[]{20.0, 18.0, 16.0, 14.0, 12.0, 10.0, 1.0};

    @Override
    public double getMaxScorePerRound() {
        return SCORES[0];
    }

    @Override
    public double[] assignScores(int[] times) {
        int t;
        double[] result = new double[times.length];
        int[] teams = new int[times.length];
        for (t = 0; t < teams.length; ++t) {
            teams[t] = t;
        }
        for (t = 0; t < times.length; ++t) {
            for (int y = t; y < times.length; ++y) {
                if (times[t] >= times[y]) continue;
                int tmp = times[t];
                times[t] = times[y];
                times[y] = tmp;
                tmp = teams[t];
                teams[t] = teams[y];
                teams[y] = tmp;
            }
        }
        double[] tmp = new double[result.length];
        int teamIdx = 0;
        int scoreIndex = 0;
        while (teamIdx < teams.length && times[teamIdx] > 0) {
            double sum = 0.0;
            int tmpIdx = teamIdx;
            do {
                sum += SCORES[scoreIndex >= SCORES.length ? SCORES.length - 1 : scoreIndex];
                ++scoreIndex;
            } while (++tmpIdx < times.length && times[tmpIdx - 1] == times[tmpIdx]);
            double avg = sum / (double)(tmpIdx - teamIdx);
            for (int t2 = teamIdx; t2 < tmpIdx; ++t2) {
                tmp[t2] = avg;
            }
            teamIdx = tmpIdx;
        }
        for (int t3 = 0; t3 < tmp.length; ++t3) {
            result[teams[t3]] = tmp[t3];
        }
        return result;
    }

    public static final int[] dumpInt(int[] a) {
        for (int t = 0; t < a.length; ++t) {
            if (t > 0) {
                System.out.print(",");
            }
            System.out.print(a[t]);
        }
        System.out.println();
        return a;
    }

    public static final double[] dumpDouble(double[] a) {
        for (int t = 0; t < a.length; ++t) {
            if (t > 0) {
                System.out.print(",");
            }
            System.out.print(a[t]);
        }
        System.out.println();
        return a;
    }

    public static void main(String[] args) {
        MoJ2005ScoringRules.dumpDouble(new MoJ2005ScoringRules().assignScores(MoJ2005ScoringRules.dumpInt(new int[]{1412, 1211, 800, 600, 500, 400, 300, 200, 100, 87, 24, 12, 9})));
        MoJ2005ScoringRules.dumpDouble(new MoJ2005ScoringRules().assignScores(MoJ2005ScoringRules.dumpInt(new int[]{10, 10, 10, 9, 8, 7})));
        MoJ2005ScoringRules.dumpDouble(new MoJ2005ScoringRules().assignScores(MoJ2005ScoringRules.dumpInt(new int[]{10, 0})));
        MoJ2005ScoringRules.dumpDouble(new MoJ2005ScoringRules().assignScores(MoJ2005ScoringRules.dumpInt(new int[]{0, 0, 0, 0, 0})));
    }
}

