/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scoreboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import nl.ctrlaltdev.ui.Build;
import nl.ctrlaltdev.ui.ImagePanel;
import nl.ctrlaltdev.util.Tool;
import nl.moj.model.State;
import nl.moj.round.StateImpl;

public class ScoreBoard
extends JPanel {
    private static final Font SCOREFONT = new Font("Courier New", 1, 16);
    private static final Color ROUNDWINNER = new Color(128, 224, 128);
    private static final Color ROUNDPLAYED = new Color(0, 192, 0);
    private static final Color ROUNDNOENTRY = new Color(128, 32, 32);
    private static final Color MATCHWINNER = new Color(192, 192, 255);
    private static final Color MATCHPLAYED = new Color(128, 128, 192);
    private static final Color GRAPHIN = new Color(192, 192, 192);
    private static final Color GRAPHOUT = new Color(128, 128, 128);
    private static final Color FAILURE = new Color(255, 128, 128);
    private static final Color SUCCESS = new Color(128, 255, 128);
    private State state;
    private String[] rounds;
    private String[] teams;

    public ScoreBoard(String[] args) throws IOException {
        super(new BorderLayout());
        String rnd;
        int r;
        String tm;
        int t;
        this.state = args.length == 0 ? new StateImpl(new File("./state.csv")) : new StateImpl(new File(args[0]));
        this.rounds = this.state.getKnownRoundNames();
        this.teams = this.state.getKnownTeams();
        JComponent[] rows = new JComponent[this.teams.length + 1];
        rows[0] = new JPanel(new GridLayout(0, this.rounds.length + 2));
        rows[0].add(new JPanel());
        for (int r2 = 0; r2 < this.rounds.length; ++r2) {
            rows[0].add(this.createRoundPanel(this.rounds[r2]));
        }
        rows[0].add(this.createRoundPanel("** TOTAL **"));
        String maxName = null;
        int max = 0;
        int[] sums = new int[this.teams.length];
        for (t = 0; t < sums.length; ++t) {
            tm = this.teams[t];
            for (r = 0; r < this.rounds.length; ++r) {
                rnd = this.rounds[r];
                int score = this.state.getScore(rnd, tm);
                if (score < 0) continue;
                sums[t] = sums[t] + score;
            }
            if (sums[t] <= max) continue;
            max = sums[t];
            maxName = tm;
        }
        for (t = 0; t < this.teams.length; ++t) {
            rows[t + 1] = new JPanel(new GridLayout(0, this.rounds.length + 2));
            tm = this.teams[t];
            rows[t + 1].add(this.createTeamPanel(this.teams[t]));
            for (r = 0; r < this.rounds.length; ++r) {
                rnd = this.rounds[r];
                rows[t + 1].add(this.createScorePanel(tm, rnd, this.renderDetails(rnd, tm)));
            }
            rows[t + 1].add(this.createTotalScorePanel(String.valueOf(sums[t]), tm.equals(maxName)));
        }
        Build.BOXY box = new Build.BOXY(rows);
        this.add((Component)box, "North");
    }

    private String renderDetails(String rnd, String tm) {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><TABLE>");
        sb.append("<TR><TD>Typed/Source Chars</TD><TD>" + this.state.getKeyStrokeFileSizeRatio(rnd, tm));
        sb.append("</TD></TR>");
        sb.append("<TR><TD>Compile Success</TD><TD>" + this.state.getCompileSuccess(rnd, tm));
        sb.append("</TD></TR>");
        sb.append("<TR><TD>Compile Failure</TD><TD>" + this.state.getCompileFailures(rnd, tm));
        sb.append("</TD></TR>");
        sb.append("<TR><TD>Test Success</TD><TD>" + this.state.getTestSuccess(rnd, tm));
        sb.append("</TD></TR>");
        sb.append("<TR><TD>Test Failure</TD><TD>" + this.state.getTestFailures(rnd, tm));
        sb.append("</TD></TR>");
        sb.append("</TABLE></HTML>");
        return sb.toString();
    }

    private JPanel createTeamPanel(String name) {
        Build.CFP p = new Build.CFP(new JLabel(name));
        p.setBorder(BorderFactory.createBevelBorder(0));
        return p;
    }

    private JPanel createScorePanel(String team, String round, String tt) {
        ScorePanel p = new ScorePanel(team, round, this.state);
        p.setToolTipText(tt);
        return p;
    }

    private JPanel createTotalScorePanel(String name, boolean winner) {
        JLabel lbl = new JLabel(name);
        Build.CFP p = new Build.CFP(lbl);
        p.setBorder(BorderFactory.createBevelBorder(0));
        p.setBackground(MATCHPLAYED);
        if (winner) {
            p.setBackground(MATCHWINNER);
        }
        return p;
    }

    private JPanel createRoundPanel(String name) {
        Build.CFP p = new Build.CFP(new JLabel(name));
        p.setBorder(BorderFactory.createBevelBorder(0));
        return p;
    }

    public static Image loadImage(String fileName) throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL myURL = ScoreBoard.class.getResource(fileName);
        if (myURL == null) {
            throw new IOException("Resource " + fileName + " not found. Does it start with / ?");
        }
        return tk.createImage(myURL);
    }

    public static void main(String[] args) throws Throwable {
        ToolTipManager.sharedInstance().setDismissDelay(5000);
        ToolTipManager.sharedInstance().setInitialDelay(500);
        ToolTipManager.sharedInstance().setReshowDelay(1000);
        Image logo = ScoreBoard.loadImage("/client/mojLogo.gif");
        JFrame f = new JFrame("Score Board");
        f.setSize(800, 600);
        ScoreBoard sc = new ScoreBoard(Tool.parseArgs(args));
        f.getContentPane().add((Component)new ImagePanel(logo, 320, 136, Color.white), "North");
        f.getContentPane().add((Component)new JScrollPane(sc), "Center");
        MediaTracker tr = new MediaTracker(f);
        tr.addImage(logo, 1);
        tr.waitForAll();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private static final class ScorePanel
    extends JPanel {
        private String myTeam;
        private String myRound;
        private State myState;
        private String score;
        private int cf;
        private int cs;
        private int tf;
        private int ts;

        public ScorePanel(String team, String round, State st) {
            this.myTeam = team;
            this.myRound = round;
            this.myState = st;
            int sc = this.myState.getScore(this.myRound, this.myTeam);
            if (sc < 0) {
                this.score = "None";
                this.setBackground(ROUNDNOENTRY);
                this.setForeground(Color.gray);
            } else {
                this.score = String.valueOf(sc);
                if (team.equals(this.myState.getRoundWinner(round))) {
                    this.setBackground(ROUNDWINNER);
                    this.setForeground(Color.black);
                } else {
                    this.setBackground(ROUNDPLAYED);
                    this.setForeground(Color.black);
                }
            }
            this.setPreferredSize(new Dimension(96, 64));
            this.cf = this.myState.getCompileFailures(this.myRound, this.myTeam);
            this.cs = this.myState.getCompileSuccess(this.myRound, this.myTeam);
            this.tf = this.myState.getTestFailures(this.myRound, this.myTeam);
            this.ts = this.myState.getTestSuccess(this.myRound, this.myTeam);
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getBackground());
            g.fill3DRect(0, 0, w, h, true);
            g.setColor(this.getForeground());
            g.setFont(SCOREFONT);
            g.drawString(this.score, 4, 14);
            g.setColor(Color.gray);
            g.drawLine(6, 20, 6, 60);
            g.drawLine(4, 60, 68, 60);
            for (int t = 0; t < 30; ++t) {
                int sz = this.myState.getFileSizeForMinute(this.myRound, this.myTeam, t);
                int tsz = this.myState.getFinalFileSize(this.myRound, this.myTeam);
                if (tsz == 0) {
                    tsz = 1;
                }
                if ((sz = 30 * sz / tsz) > 42) {
                    sz = 42;
                }
                g.setColor(GRAPHOUT);
                g.fillRect(7 + t * 2, 59 - sz, 2, sz);
                g.setColor(GRAPHIN);
                g.drawRect(7 + t * 2, 59 - sz, 2, sz);
            }
            this.drawBar(g, this.cf, this.cs, this.cf + this.cs, 72, 42, 24.0);
            this.drawBar(g, this.tf, this.ts, this.tf + this.ts, 72, 46, 24.0);
        }

        private void drawBar(Graphics g, double f, double s, double sum, int x, int y, double w) {
            double d = w / sum;
            double l = f * d;
            double r = s * d;
            g.setColor(FAILURE);
            g.fillRect(x, y, (int)l, 2);
            g.setColor(SUCCESS);
            g.fillRect((int)((double)x + l), y, (int)r, 2);
        }
    }
}

