/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.scheduler;

import java.util.Calendar;
import java.util.Date;
import nl.moj.model.Round;
import nl.moj.model.Scheduler;

class ScheduledRoundImpl
implements Scheduler.ScheduledRound {
    private Date open;
    private Date start;
    private Round round;
    private String failure;

    public ScheduledRoundImpl(Date open, Date start, Round round) {
        if (open == null) {
            throw new NullPointerException("NULL open time.");
        }
        if (start == null) {
            throw new NullPointerException("NULL start time.");
        }
        if (start.before(new Date())) {
            throw new IllegalArgumentException("Start time must be in the future.");
        }
        if (start.before(open)) {
            throw new IllegalArgumentException("Start time must be after Open time.");
        }
        this.start = start;
        this.open = open;
        this.round = round;
    }

    @Override
    public Round getRound() {
        return this.round;
    }

    @Override
    public Date getOpenTime() {
        return this.open;
    }

    @Override
    public Date getStartTime() {
        return this.start;
    }

    @Override
    public Date getEstimatedEndTime() {
        return this.addRoundDuration(this.start);
    }

    protected Date addRoundDuration(Date d) {
        int mins = this.round.getAssignment().getDuration();
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(12, mins);
        return c.getTime();
    }

    @Override
    public boolean activeIn(Date rangeStart, Date rangeEnd) {
        Date estEnd;
        if (rangeEnd == null) {
            rangeEnd = this.addRoundDuration(rangeStart);
        }
        if (rangeStart.after(estEnd = this.getEstimatedEndTime())) {
            return false;
        }
        return !rangeEnd.before(this.open);
    }

    @Override
    public boolean isStarted() {
        return this.round.isStarted();
    }

    @Override
    public boolean isRunning() {
        return this.round.isStarted() && !this.round.isFinished();
    }

    @Override
    public boolean isFinished() {
        return this.round.isFinished();
    }

    @Override
    public String getFailure() {
        return this.failure;
    }

    @Override
    public void setFailure(String failure) {
        this.failure = failure;
    }

    @Override
    public boolean isFailed() {
        return this.failure != null;
    }
}

