/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.round;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.client.anim.Anim;
import nl.moj.model.Assignment;
import nl.moj.model.Clock;
import nl.moj.model.GameRules;
import nl.moj.model.Operation;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;
import nl.moj.model.Workspace;
import nl.moj.operation.ContextImpl;
import nl.moj.process.ProcessPool;
import nl.moj.sfx.SoundEffects;
import nl.moj.workspace.factory.WorkspaceFactory;

public class TeamImpl
implements Team,
ProcessPool.ProcessListener,
OutputRedirector.Target,
Clock.Notification {
    private static long OPERATION_TIMEOUT = 45000L;
    private String myName;
    private String myPWD;
    private String myDisplayName;
    private boolean[] mySubmitTestResults;
    private int[] myLatestTestResults;
    private Anim[] myLatestAnimationTestResults;
    private int[] myOldTestResults;
    private int myUploadTime;
    private Logger myLog;
    private List<String[]> myLines;
    private StringBuffer sb = new StringBuffer();
    private State.Writer myStateWriter;
    private Workspace theWorkspace;
    private Assignment myAssignment;
    private SoundEffects sfx;
    private Clock myClock;
    private GameRules gameRules;
    private boolean online;
    private boolean disqualified;
    private long myCurrentOperationStartTime;
    private Operation myCurrentOperation;
    public static final int MAX_LINES = 1500;

    public TeamImpl(String name, String displayName, String pwd, Assignment a, GameRules rules, State.Writer wr, SoundEffects sfx) {
        if (name == null) {
            throw new NullPointerException("Team name is null.");
        }
        this.myName = name;
        this.myDisplayName = displayName;
        this.myPWD = pwd;
        this.myUploadTime = 0;
        this.myLog = Logger.getLogger(this.myName);
        this.myLines = new ArrayList<String[]>();
        this.myStateWriter = wr;
        this.myAssignment = a;
        this.gameRules = rules;
        this.myClock = rules.getClock(this);
        this.myClock.addNotifier(this);
        this.sfx = sfx;
    }

    public void setWorkspace(Workspace sp) {
        if (this.theWorkspace == null) {
            this.theWorkspace = sp;
        }
    }

    public void initWorkspace(WorkspaceFactory wf) throws IOException {
        this.setWorkspace(wf.createWorkspace(this.myName, this, this));
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public boolean isScoreAvailable() {
        return this.isFinished() && this.mySubmitTestResults != null;
    }

    @Override
    public boolean[] getSubmitTestResults() {
        if (this.mySubmitTestResults == null) {
            return null;
        }
        boolean[] copy = new boolean[this.mySubmitTestResults.length];
        for (int t = 0; t < this.mySubmitTestResults.length; ++t) {
            copy[t] = this.mySubmitTestResults[t];
        }
        return copy;
    }

    @Override
    public int getSubmitTime() {
        return this.myUploadTime;
    }

    @Override
    public Workspace getWorkspace() {
        if (this.theWorkspace == null) {
            throw new NullPointerException("Workspace not set.");
        }
        return this.theWorkspace;
    }

    @Override
    public Assignment getAssignment() {
        return this.myAssignment;
    }

    @Override
    public Clock getClock() {
        return this.myClock;
    }

    @Override
    public GameRules getGameRules() {
        return this.gameRules;
    }

    @Override
    public synchronized int[] getTestResults() {
        if (this.myLatestTestResults == null) {
            return null;
        }
        int[] tmp = this.myLatestTestResults;
        this.myLatestTestResults = null;
        return tmp;
    }

    @Override
    public synchronized Anim[] getAnimatedTestResults() {
        if (this.myLatestAnimationTestResults == null) {
            return null;
        }
        Anim[] tmp = this.myLatestAnimationTestResults;
        this.myLatestAnimationTestResults = null;
        return tmp;
    }

    @Override
    public int[] getOldTestResults() {
        return this.myOldTestResults;
    }

    @Override
    public void clearOldResults() {
        this.myOldTestResults = null;
    }

    public boolean canDisqualify() {
        return !this.isDisqualified() && this.isPlaying();
    }

    @Override
    public boolean isDisqualified() {
        return this.disqualified;
    }

    @Override
    public boolean isWaiting() {
        return this.gameRules.getState(this) == 0;
    }

    @Override
    public boolean isFinished() {
        return this.gameRules.getState(this) == 2;
    }

    @Override
    public boolean isPlaying() {
        return this.gameRules.getState(this) == 1;
    }

    @Override
    public boolean isValidPassword(String pwd) {
        boolean ok = this.myPWD.equals(pwd);
        if (ok) {
            this.online = true;
        }
        if (pwd == null) {
            this.online = false;
        }
        return ok;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public int getFinalScore() {
        return this.gameRules.getFinalScore(this);
    }

    @Override
    public int getTheoreticalScore() {
        return this.gameRules.getTheoreticalMaximumScore(this);
    }

    public int getSecondsInitial() {
        return this.myClock.getDuration();
    }

    public int getSecondsRemaining() {
        return this.myClock.getSecondsRemaining();
    }

    @Override
    public synchronized boolean isPerformingOperation() {
        return this.myCurrentOperation != null;
    }

    @Override
    public synchronized Operation getCurrentOperation() {
        return this.myCurrentOperation;
    }

    @Override
    public synchronized void doOperation(Operation op, Operation.Context ctx) {
        if (this.isPlaying() && !this.isPerformingOperation()) {
            this.myLog.info("Performing : " + op.getName());
            if (op.isSubmit()) {
                this.markSubmitting();
            }
            this.getWorkspace().perform(op, ctx);
            this.myCurrentOperationStartTime = System.currentTimeMillis();
            this.myCurrentOperation = op;
        } else if (this.isPlaying()) {
            this.addLine(null, "Still busy.");
            if (System.currentTimeMillis() - this.myCurrentOperationStartTime > OPERATION_TIMEOUT) {
                String msg = "Operation took longer than " + OPERATION_TIMEOUT / 1000L + " seconds. Aborting.";
                this.addLine(null, msg);
                this.myLog.warning(msg);
                this.complete(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        }
    }

    @Override
    public OutputRedirector.Target getTarget() {
        return this;
    }

    @Override
    public void append(String ctx, String s) {
        this.sb.append(s);
        if (this.sb.length() > 1024) {
            this.sb.append("\n");
        }
        int idx = -1;
        while ((idx = this.sb.indexOf("\n")) >= 0) {
            String sub = this.sb.substring(0, idx);
            this.addLine(ctx, sub);
            this.sb.delete(0, idx + 1);
        }
    }

    @Override
    public void complete(Runnable r) {
        if (r instanceof Team.Results) {
            Operation op = ((Team.Results)((Object)r)).getOperation();
            boolean submit = op.isSubmit();
            if (r instanceof Team.TestResults) {
                Team.TestResults tr = (Team.TestResults)((Object)r);
                if (tr.getTestResults() == null) {
                    if (submit) {
                        this.markFailed(new boolean[]{false});
                    } else {
                        this.logEndTest(new int[]{-1}, null);
                    }
                } else if (submit) {
                    if (tr.getTestResults().isOk()) {
                        this.markSuccess(tr.getTestResults().getScore());
                    } else {
                        this.markFailed(tr.getTestResults().getScore());
                    }
                } else {
                    this.logEndTest(tr.getTestResults().getResults(), tr.getTestResults().getAnimationOutput());
                }
            } else if (r instanceof Team.CompileResults) {
                this.addCompileSuccess(((Team.CompileResults)((Object)r)).wasSuccess());
                if (submit) {
                    this.markFailed(new boolean[]{false});
                }
            } else if (submit) {
                this.markFailed(new boolean[]{false});
            }
        }
        this.myCurrentOperation = null;
        this.addLine(null, "Complete.");
    }

    @Override
    public void executing(Runnable r) {
        this.addLine(null, "Running.");
    }

    @Override
    public void queued(Runnable r) {
        this.addLine(null, "Queued.");
    }

    protected synchronized void addLine(String ctx, String line) {
        if (this.myLines.size() > 1500) {
            return;
        }
        if (this.myLines.size() == 1500) {
            Logger.getLogger(this.getName()).warning("Team '" + this.getName() + "' is generating lots of output.");
        }
        this.myLines.add(new String[]{ctx, line});
    }

    protected synchronized void addLines(String ctx, String[] lines) {
        if (this.myLines.size() + lines.length > 1500) {
            return;
        }
        for (int t = 0; t < lines.length; ++t) {
            this.myLines.add(new String[]{ctx, lines[t]});
        }
    }

    @Override
    public synchronized String[][] getLines() {
        String[][] result = (String[][])this.myLines.toArray((T[])new String[this.myLines.size()][]);
        this.myLines.clear();
        return result;
    }

    protected void markSubmitting() {
        if (this.isPlaying() && this.myUploadTime == 0) {
            this.myUploadTime = this.myClock.getSecondsPassed();
            this.myStateWriter.submit(this, this.myUploadTime);
        }
    }

    protected boolean hasSubmitted() {
        return this.myUploadTime != 0;
    }

    protected void markSuccess(boolean[] r) {
        if (this.mySubmitTestResults == null) {
            this.mySubmitTestResults = r;
            this.myStateWriter.score(this);
            if (this.sfx != null) {
                this.sfx.submitSuccess();
            }
        }
    }

    protected void markFailed(boolean[] r) {
        if (this.mySubmitTestResults == null) {
            this.mySubmitTestResults = r;
            this.myStateWriter.score(this);
            if (this.sfx != null) {
                this.sfx.submitFailed();
            }
        }
    }

    protected synchronized void logEndTest(int[] testResults, Anim[] animResults) {
        this.myLatestTestResults = testResults;
        this.myLatestAnimationTestResults = animResults;
        this.myOldTestResults = testResults;
        for (int t = 0; t < testResults.length; ++t) {
            if (testResults[t] < 0) {
                this.myStateWriter.testFailure(this);
            }
            if (testResults[t] <= 0) continue;
            this.myStateWriter.testSuccess(this);
        }
    }

    @Override
    public void disqualify(Object caller) {
        if (this.canDisqualify()) {
            if (!EventQueue.isDispatchThread()) {
                throw new RuntimeException("Cannot Disqualify. Reason : not on Dispatch Thread.");
            }
            this.disqualified = true;
            this.myStateWriter.submit(this, this.myClock.getSecondsPassed());
            this.myStateWriter.score(this);
        }
    }

    @Override
    public void load(Round r, State s) {
        if (s.isComplete(r, this)) {
            int score = s.getScore(r, this);
            if (score < 0) {
                this.myUploadTime = s.getSubmitTime(r, this);
                Operation[] o = this.myAssignment.getOperations();
                for (int t = 0; t < o.length; ++t) {
                    if (!o[t].isSubmit()) continue;
                    this.getWorkspace().perform(o[t], new ContextImpl());
                    return;
                }
            } else if (score == 0) {
                this.mySubmitTestResults = new boolean[]{false};
            } else {
                this.myUploadTime = s.getSubmitTime(r, this);
                this.mySubmitTestResults = new boolean[]{true};
            }
        }
    }

    @Override
    public void addStatistics(int keyStrokes, String operation, int size) {
        this.myStateWriter.keyStrokes(this, keyStrokes);
        this.myStateWriter.operation(this, operation);
        this.myStateWriter.solutionSize(this, size);
    }

    private void addCompileSuccess(boolean ok) {
        if (ok) {
            this.myStateWriter.compileSuccess(this);
        } else {
            this.myStateWriter.compileFailure(this);
        }
    }

    @Override
    public void clockReset() {
    }

    @Override
    public void clockFinished() {
        if (!this.isScoreAvailable() && !this.hasSubmitted()) {
            this.myLog.log(Level.INFO, "TIMEUP : score=" + this.getFinalScore());
            this.myStateWriter.timeRemaining(this, 0);
            this.myStateWriter.finish(this);
            this.myStateWriter.submit(this, this.myClock.getSecondsPassed());
            this.myStateWriter.score(this);
        } else {
            this.myStateWriter.finish(this);
        }
    }

    @Override
    public void clockStarted() {
        if (this.myClock.isStartPosition()) {
            this.myStateWriter.start(this);
        } else {
            this.myStateWriter.resume(this);
        }
    }

    @Override
    public void clockStopped() {
        this.myStateWriter.pause(this);
    }

    @Override
    public void minutePassed(int remaining) {
        this.myStateWriter.timeRemaining(this, remaining * 60);
    }
}

