/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.operation;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.moj.compile.Compiler;
import nl.moj.model.Operation;
import nl.moj.model.Team;
import nl.moj.model.Workspace;
import nl.moj.process.ProcessPool;

public abstract class AbstractOperationRunnable
implements Runnable,
ProcessPool.ProcessListener,
Team.Results {
    private Operation owner;
    private Workspace.Internal workspace;
    private Operation.Context context;

    public AbstractOperationRunnable(Operation owner, Workspace.Internal ws, Operation.Context ctx) {
        this.owner = owner;
        this.workspace = ws;
        this.context = ctx;
    }

    @Override
    public void complete(Runnable r) {
    }

    @Override
    public void executing(Runnable r) {
    }

    @Override
    public void queued(Runnable r) {
    }

    @Override
    public abstract void run();

    protected Workspace.Internal getWorkspace() {
        return this.workspace;
    }

    protected Operation.Context getContext() {
        return this.context;
    }

    @Override
    public Operation getOperation() {
        return this.owner;
    }

    protected void save() throws IOException {
        String[] files = this.context.getNames();
        for (int t = 0; t < files.length; ++t) {
            String cmp;
            String src = this.getWorkspace().getContents(files[t]);
            if (src.equals(cmp = this.context.getContents(files[t]))) continue;
            this.getWorkspace().save(files[t], cmp);
        }
    }

    protected boolean compile() throws IOException {
        try {
            return new Compiler().compile(this.getWorkspace());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger("Compiler").log(Level.SEVERE, ex.getMessage() + " : Is the tools.jar (J2SDK) on the classpath ?");
            return false;
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger("Compiler").log(Level.SEVERE, ex.getMessage() + " : Are you using JDK 1.4.2_04 or better ?");
            return false;
        }
    }
}

