/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.mgmt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import nl.ctrlaltdev.util.Encoder;
import nl.ctrlaltdev.util.Tool;

public class TeamProfileList {
    private static final String HEX = "0123456789ABCDEF";
    public static final String WELKOM = "604F7D0C789F79B50303C9DF83F405ADF3007955";
    private static final String VALIDNAMECHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private List teams = new ArrayList();
    private List passwords = new ArrayList();
    private List displayNames = new ArrayList();
    private List excludedAssignments = new ArrayList();
    private List registrationIndex = new ArrayList();

    private static String getString(ResourceBundle rb, String name, String std) {
        try {
            return rb.getString(name);
        }
        catch (MissingResourceException ex) {
            return std;
        }
    }

    public TeamProfileList() {
    }

    public TeamProfileList(File f) throws IOException {
        this(new FileInputStream(f));
    }

    public TeamProfileList(InputStream in) throws IOException {
        this(new PropertyResourceBundle(in));
    }

    public TeamProfileList(ResourceBundle res) {
        Object[] tmp = Tool.cut(res.getString("TEAMS"), ",");
        Arrays.sort(tmp);
        for (int t = 0; t < tmp.length; ++t) {
            String pwd = res.getString((String)tmp[t] + ".PWD");
            String name = TeamProfileList.getString(res, (String)tmp[t] + ".NAME", (String)tmp[t]);
            String exclude = TeamProfileList.getString(res, (String)tmp[t] + ".EXCLUDE", "");
            String idx = TeamProfileList.getString(res, (String)tmp[t] + ".INDEX", "-1");
            this.checkTeamName((String)tmp[t]);
            this.checkPassword(pwd);
            this.checkDisplayName((String)tmp[t], name);
            this.checkExclude(exclude);
            this.teams.add(tmp[t]);
            this.passwords.add(pwd);
            this.displayNames.add(name);
            this.excludedAssignments.add(exclude);
            this.registrationIndex.add(new Integer(Integer.parseInt(idx)));
        }
    }

    public int getIndexOfTeam(String teamName) {
        for (int t = 0; t < this.teams.size(); ++t) {
            if (!this.getTeamName(t).equals(teamName)) continue;
            return t;
        }
        return -1;
    }

    public int getNumberOfTeams() {
        return this.teams.size();
    }

    public String getTeamName(int nr) {
        this.checkIndex(nr);
        return (String)this.teams.get(nr);
    }

    public String getPassword(int nr) {
        this.checkIndex(nr);
        return (String)this.passwords.get(nr);
    }

    public String getDisplayName(int nr) {
        this.checkIndex(nr);
        return (String)this.displayNames.get(nr);
    }

    public String getExcludeAssignment(int nr) {
        this.checkIndex(nr);
        return (String)this.excludedAssignments.get(nr);
    }

    public Integer getRegistrationIndex(int nr) {
        this.checkIndex(nr);
        return (Integer)this.registrationIndex.get(nr);
    }

    public boolean isEncodedPassword(int idx) {
        String pwd = this.getPassword(idx);
        int cnt = 0;
        for (int t = 0; t < pwd.length(); ++t) {
            if (HEX.indexOf(pwd.charAt(t)) < 0) continue;
            ++cnt;
        }
        return cnt == WELKOM.length();
    }

    public void setTeamName(int idx, String name) {
        this.checkIndex(idx);
        this.checkTeamName(name);
        this.teams.set(idx, name);
    }

    public void setDisplayName(int idx, String displayName) {
        this.checkIndex(idx);
        displayName = this.checkDisplayName(this.getTeamName(idx), displayName);
        this.displayNames.set(idx, displayName);
    }

    public void setPassword(int idx, String pwd) {
        this.checkIndex(idx);
        this.checkPassword(pwd);
        this.passwords.set(idx, pwd);
    }

    public void setExcludedAssignment(int idx, String ex) {
        this.checkIndex(idx);
        this.checkExclude(ex);
        this.excludedAssignments.set(idx, ex);
    }

    protected void checkIndex(int idx) {
        if (idx < 0 || idx >= this.teams.size()) {
            throw new RuntimeException("Invalid Team index.");
        }
    }

    protected void checkTeamName(String name) {
        if (name == null || name.length() == 0) {
            throw new RuntimeException("Cannot have a team with an empty or NULL name.");
        }
        name = name.toUpperCase();
        for (int t = 0; t < name.length(); ++t) {
            if (VALIDNAMECHARS.indexOf(name.charAt(t)) >= 0) continue;
            throw new RuntimeException("Invalid character '" + name.charAt(t) + "' in name " + name);
        }
    }

    protected void checkPassword(String pwd) {
        if (pwd == null || pwd.length() == 0) {
            throw new RuntimeException("Cannot have a team with an empty NULL or password.");
        }
    }

    protected void checkExclude(String ex) {
    }

    protected String checkDisplayName(String name, String displayName) {
        if (displayName == null || displayName.length() == 0) {
            displayName = name;
        }
        return displayName;
    }

    public void addTeam(String name, String pwd, String displayName, String ex) {
        this.checkTeamName(name);
        this.checkPassword(pwd);
        displayName = this.checkDisplayName(name, displayName);
        this.checkExclude(ex);
        if (this.teams.contains(name)) {
            throw new RuntimeException("Duplicate name : " + name);
        }
        if (displayName == null || displayName.length() == 0) {
            displayName = name;
        }
        this.teams.add(name);
        this.passwords.add(pwd);
        this.displayNames.add(displayName);
        this.excludedAssignments.add(ex);
        this.registrationIndex.add(new Integer(this.registrationIndex.size()));
    }

    public void deleteTeam(int idx) {
        this.checkIndex(idx);
        this.teams.remove(idx);
        this.passwords.remove(idx);
        this.displayNames.remove(idx);
        this.excludedAssignments.remove(idx);
        this.registrationIndex.remove(idx);
    }

    public int[] getRegistrationSequence() {
        int t;
        boolean invalid = false;
        int[] sx = new int[this.registrationIndex.size()];
        int[] tx = new int[this.registrationIndex.size()];
        for (t = 0; t < tx.length; ++t) {
            sx[t] = t;
            tx[t] = this.getRegistrationIndex(t);
            if (tx[t] >= 0) continue;
            invalid = true;
        }
        if (invalid) {
            for (t = 0; t < tx.length; ++t) {
                tx[t] = t;
            }
            return tx;
        }
        for (t = 0; t < tx.length; ++t) {
            for (int y = t; y < tx.length; ++y) {
                if (tx[t] <= tx[y]) continue;
                int tmp = tx[t];
                tx[t] = tx[y];
                tx[y] = tmp;
                tmp = sx[t];
                sx[t] = sx[y];
                sx[y] = tmp;
            }
        }
        return sx;
    }

    public void save(OutputStream out, boolean encode) throws IOException, NoSuchAlgorithmException {
        BufferedWriter wout = new BufferedWriter(new OutputStreamWriter(out));
        wout.write("#");
        wout.newLine();
        wout.write("# Team properties : Indentifies teams and their passwords.");
        wout.newLine();
        wout.write("# As these are constant for multiple rounds, they are in a ");
        wout.newLine();
        wout.write("# separate file.");
        wout.newLine();
        wout.write("#");
        wout.newLine();
        wout.write("TEAMS=" + Tool.arrayToString(this.teams.toArray()));
        wout.newLine();
        for (int t = 0; t < this.teams.size(); ++t) {
            if (this.isEncodedPassword(t)) {
                wout.write(this.teams.get(t) + ".PWD=" + this.passwords.get(t));
            } else {
                if (encode) {
                    this.passwords.set(t, Encoder.hash(this.passwords.get(t).toString()));
                }
                wout.write(this.teams.get(t) + ".PWD=" + this.passwords.get(t));
            }
            wout.newLine();
            if (!this.teams.get(t).equals(this.displayNames.get(t))) {
                wout.write(this.teams.get(t) + ".NAME=" + this.displayNames.get(t));
                wout.newLine();
            }
            if (this.excludedAssignments.get(t) != null) {
                wout.write(this.teams.get(t) + ".EXCLUDE=" + this.excludedAssignments.get(t));
                wout.newLine();
            }
            if (this.registrationIndex.get(t) == null) continue;
            wout.write(this.teams.get(t) + ".INDEX=" + this.registrationIndex.get(t));
            wout.newLine();
        }
        wout.newLine();
        wout.flush();
    }

    public void saveAsCSV(OutputStream out, String[] lineup) throws IOException {
        BufferedWriter wout = new BufferedWriter(new OutputStreamWriter(out));
        wout.write("Nr;Login;Password;DisplayName;ExcludedAssignment;ExcludedRound;");
        wout.newLine();
        int[] seq = this.getRegistrationSequence();
        for (int t = 0; t < this.teams.size(); ++t) {
            int idx = seq[t];
            wout.write(String.valueOf((Integer)this.registrationIndex.get(idx) + 1));
            wout.write(";");
            wout.write(String.valueOf(this.teams.get(idx)));
            wout.write(";");
            wout.write(String.valueOf(this.passwords.get(idx)));
            wout.write(";");
            wout.write(String.valueOf(this.displayNames.get(idx)));
            wout.write(";");
            wout.write(String.valueOf(this.excludedAssignments.get(idx)));
            wout.write(";");
            boolean found = false;
            for (int r = 0; r < lineup.length; ++r) {
                if (!this.excludedAssignments.get(idx).equals(lineup[r])) continue;
                wout.write(String.valueOf(r + 1));
                found = true;
            }
            if (!found) {
                wout.write("-1");
            }
            wout.write(";");
            wout.newLine();
        }
        wout.flush();
    }
}

