/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.mgmt;

import java.io.File;
import nl.moj.round.StateImpl;

public class Statalyzer {
    private static String fix(String s, int l) {
        if (s.length() >= l) {
            return s.substring(0, l - 1) + " ";
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < l) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        StateImpl state = new StateImpl(new File(args[0]));
        String[] rounds = state.getKnownRoundNames();
        String[] teams = state.getKnownTeams();
        for (int r = 0; r < rounds.length; ++r) {
            double success = 0.0;
            double fail = 0.0;
            double sum = 0.0;
            double avgFileSize = 0.0;
            double minFileSize = 2.147483646E9;
            double maxFileSize = 0.0;
            double avgFileSizeAll = 0.0;
            double minFileSizeAll = 2.147483646E9;
            double maxFileSizeAll = 0.0;
            double compileFailure = 0.0;
            double compileSuccess = 0.0;
            double compileFailureAll = 0.0;
            double compileSuccessAll = 0.0;
            double testFailure = 0.0;
            double testSuccess = 0.0;
            double testFailureAll = 0.0;
            double testSuccessAll = 0.0;
            double keystroke = 0.0;
            double keystrokeMax = 0.0;
            double keystrokeMin = 2.147483646E9;
            for (int t = 0; t < teams.length; ++t) {
                double fz;
                int time = state.getScore(rounds[r], teams[t]);
                if (time >= 0) {
                    success += 1.0;
                } else {
                    fail += 1.0;
                }
                sum += 1.0;
                if (time > 0) {
                    fz = state.getFinalFileSize(rounds[r], teams[t]);
                    if (fz < minFileSize) {
                        minFileSize = fz;
                    }
                    if (fz > maxFileSize) {
                        maxFileSize = fz;
                    }
                    avgFileSize += fz;
                    compileFailure += (double)state.getCompileSuccess(rounds[r], teams[t]);
                    compileSuccess += (double)state.getCompileFailures(rounds[r], teams[t]);
                    compileSuccess += (double)(state.getTestSuccess(rounds[r], teams[t]) / 7);
                    compileSuccess += (double)(state.getTestFailures(rounds[r], teams[t]) / 7);
                    testSuccess += (double)state.getTestSuccess(rounds[r], teams[t]);
                    testFailure += (double)state.getTestFailures(rounds[r], teams[t]);
                }
                if ((fz = (double)state.getFinalFileSize(rounds[r], teams[t])) < minFileSizeAll && fz > 0.0) {
                    minFileSizeAll = fz;
                }
                if (fz > maxFileSizeAll) {
                    maxFileSizeAll = fz;
                }
                avgFileSizeAll += fz;
                compileFailureAll += (double)state.getCompileSuccess(rounds[r], teams[t]);
                compileSuccessAll += (double)state.getCompileFailures(rounds[r], teams[t]);
                compileSuccessAll += (double)(state.getTestSuccess(rounds[r], teams[t]) / 7);
                compileSuccessAll += (double)(state.getTestFailures(rounds[r], teams[t]) / 7);
                testSuccessAll += (double)state.getTestSuccess(rounds[r], teams[t]);
                testFailureAll += (double)state.getTestFailures(rounds[r], teams[t]);
                int str = state.getNrOfKeystrokes(rounds[r], teams[t]);
                keystroke += (double)str;
                if ((double)str < keystrokeMin && str > 0) {
                    keystrokeMin = str;
                }
                if (!((double)str > keystrokeMax)) continue;
                keystrokeMax = str;
            }
            System.out.println(Statalyzer.fix(rounds[r], 16) + Statalyzer.fix("success", 12) + " : " + Statalyzer.fix(Math.round(success) + "/" + Math.round(sum), 8) + " successful solutions (" + Math.round(100.0 * success / sum) + " %)");
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("size success", 12) + " : AVG " + Math.round(avgFileSize / success) + ", MIN " + Math.round(minFileSize) + ", MAX " + Math.round(maxFileSize));
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("size all", 12) + " : AVG " + Math.round(avgFileSizeAll / (double)teams.length) + ", MIN " + Math.round(minFileSizeAll) + ", MAX " + Math.round(maxFileSizeAll));
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("compile success", 12) + " : AVG " + Math.round(compileSuccess / success) + "/" + Math.round((compileFailure + compileSuccess) / success) + " successful compiles (" + Math.round(100.0 * compileSuccess / (compileSuccess + compileFailure)) + " %)");
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("compile all", 12) + " : AVG " + Math.round(compileSuccessAll / (double)teams.length) + "/" + Math.round((compileFailureAll + compileSuccessAll) / (double)teams.length) + " successful compiles (" + Math.round(100.0 * compileSuccessAll / (compileSuccessAll + compileFailureAll)) + " %)");
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("test success", 12) + " : AVG " + Math.round(testSuccess / success) + "/" + Math.round((testFailure + testSuccess) / success) + " successful tests (" + Math.round(100.0 * testSuccess / (testFailure + testSuccess)) + " %)");
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("test all", 12) + " : AVG " + Math.round(testSuccessAll / (double)teams.length) + "/" + Math.round((testFailureAll + testSuccessAll) / (double)teams.length) + " successful tests (" + Math.round(100.0 * testSuccessAll / (testFailureAll + testSuccessAll)) + " %)");
            System.out.println(Statalyzer.fix("", 16) + Statalyzer.fix("keystrokes all", 12) + " : AVG " + Math.round(keystroke / (double)teams.length) + ", MIN " + Math.round(keystrokeMin) + ", MAX " + Math.round(keystrokeMax));
            System.out.println();
        }
    }
}

