/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.gfx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.moj.banner.BannerPanel;
import nl.moj.gfx.ops.CompilingFx;
import nl.moj.gfx.ops.FinishedFx;
import nl.moj.gfx.ops.SavingFx;
import nl.moj.gfx.ops.SubmittingFx;
import nl.moj.gfx.ops.TestingFx;
import nl.moj.gfx.ops.TypingFx;
import nl.moj.gfx.ops.WaitingFx;
import nl.moj.model.Round;
import nl.moj.model.Team;
import nl.moj.round.TeamImpl;

public class RoundList
extends JPanel {
    private static final int TEAMWIDTH = 240;
    private static final Color BACKGROUNDCOLOR = new Color(240, 240, 240);
    private static final Color BACKGROUNDCOLOR2 = new Color(224, 224, 224);
    public static final Font normal = new Font("Courier New", 1, 16);
    public static final Font small = new Font("Courier New", 1, 12);
    private List imageList = new ArrayList();

    public RoundList(Round r, BannerPanel bp, ApplicationBuilder parent) throws ApplicationBuilder.BuildException {
        super(new BorderLayout());
        JPanel tmp = new JPanel(new BorderLayout());
        JPanel tmp1 = new JPanel(new BorderLayout());
        JPanel tmp2 = new JPanel();
        if (r.getAllTeams().length <= 14) {
            tmp2.setLayout(new BoxLayout(tmp2, 1));
        } else {
            tmp2.setLayout(new GridLayout(0, 2));
        }
        tmp1.add((Component)tmp2, "North");
        this.add((Component)tmp, "Center");
        this.setBackground(BACKGROUNDCOLOR);
        JScrollPane sp = new JScrollPane(tmp1){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        tmp2.setBackground(BACKGROUNDCOLOR2);
        tmp.add((Component)sp, "Center");
        VisualEffect[] fx = this.getEffects(parent);
        MediaTracker tr = new MediaTracker(this);
        for (int t = 0; t < this.imageList.size(); ++t) {
            tr.addImage((Image)this.imageList.get(t), 1);
        }
        tr.checkAll(true);
        Team[] tm = r.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            tmp2.add(new TeamPanel(tm[t], fx));
        }
        bp.setPreferredSize(new Dimension(252, 104));
        bp.setBackground(BACKGROUNDCOLOR);
        this.add((Component)bp, "South");
    }

    public Image loadImage(String fileName) {
        URL myURL = RoundList.class.getResource(fileName);
        if (myURL == null) {
            Logger.getLogger("").warning("Resource " + fileName + " not found. Does it start with / ?");
            return this.createImage(1, 1);
        }
        try {
            return ImageIO.read(myURL);
        }
        catch (IOException ex) {
            Logger.getLogger("").warning("Resource " + fileName + " not loaded : " + ex);
            return this.createImage(1, 1);
        }
    }

    public VisualEffect[] getEffects(ApplicationBuilder parent) throws ApplicationBuilder.BuildException {
        ArrayList<Class<WaitingFx>> l = new ArrayList<Class<WaitingFx>>();
        l.add(CompilingFx.class);
        l.add(FinishedFx.class);
        l.add(SavingFx.class);
        l.add(SubmittingFx.class);
        l.add(TestingFx.class);
        l.add(TypingFx.class);
        l.add(WaitingFx.class);
        this.addCustomFxClasses(l);
        ApplicationBuilder ab = new ApplicationBuilder(parent);
        ab.register(RoundList.class, this);
        Class[] src = l.toArray(new Class[l.size()]);
        VisualEffect[] dst = new VisualEffect[l.size()];
        ab.build(src);
        for (int t = 0; t < src.length; ++t) {
            dst[t] = (VisualEffect)ab.get(src[t]);
        }
        return dst;
    }

    protected void addCustomFxClasses(List l) {
    }

    public class TeamPanel
    extends JPanel
    implements ActionListener {
        private JPopupMenu popup = new JPopupMenu("Options");
        private JMenuItem disqualify = new JMenuItem("Disqualify");
        private Team myTeam;
        private VisualEffect[] myFx;
        private VisualEffect lastFx;
        private int frameCnt;

        public TeamPanel(Team t, VisualEffect[] img) {
            this.myTeam = t;
            this.myFx = img;
            this.setPreferredSize(new Dimension(232, 42));
            this.setMaximumSize(new Dimension(252, 42));
            this.disqualify.setText(this.disqualify.getText() + " - " + this.myTeam.getDisplayName());
            this.popup.add(this.disqualify);
            this.disqualify.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && !TeamPanel.this.popup.isVisible()) {
                        TeamPanel.this.disqualify.setEnabled(((TeamImpl)TeamPanel.this.myTeam).canDisqualify());
                        TeamPanel.this.popup.show(TeamPanel.this, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.mousePressed(e);
                    }
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            g.setFont(normal);
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.gray);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.setFont(normal);
            g.drawString(this.myTeam.getDisplayName(), 4, 18);
            VisualEffect fx = this.lastFx;
            if (fx == null || !fx.qualifies(this.myTeam)) {
                for (int t = 0; t < this.myFx.length; ++t) {
                    if (!this.myFx[t].qualifies(this.myTeam)) continue;
                    this.frameCnt = 0;
                    fx = this.myFx[t];
                    break;
                }
            }
            if (fx != null) {
                g.setFont(small);
                fx.paint(this.myTeam, g, this.frameCnt, this);
                ++this.frameCnt;
                this.lastFx = fx;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.disqualify)) {
                this.doDisqualify();
            } else {
                Logger.getLogger("").warning("Spurious action event : " + e);
            }
        }

        private void doDisqualify() {
            int r = JOptionPane.showConfirmDialog(this, "Disqualify " + this.myTeam.getDisplayName() + " ?", "Disqualification", 0);
            if (r == 0) {
                this.myTeam.disqualify(this);
            }
        }
    }

    public static interface VisualEffect {
        public void paint(Team var1, Graphics var2, int var3, Component var4);

        public boolean qualifies(Team var1);
    }
}

