/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.gamerules;

import java.util.HashMap;
import java.util.Map;
import nl.moj.clock.ReadOnlyClock;
import nl.moj.clock.SimpleClock;
import nl.moj.model.Clock;
import nl.moj.model.GameRules;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;

public class IndividualGameRules
implements GameRules {
    private Map clock = new HashMap();
    private Map rwClock = new HashMap();
    private int duration;

    public IndividualGameRules(int durationInMinutes) {
        this.duration = durationInMinutes;
    }

    @Override
    public synchronized Clock getClock(Team t) {
        Clock c = (Clock)this.clock.get(t);
        if (c == null) {
            c = new SimpleClock(this.duration);
            this.rwClock.put(t, c);
            this.clock.put(t, new ReadOnlyClock(c));
        }
        return c;
    }

    private synchronized Clock getRWClock(Team t) {
        return (Clock)this.rwClock.get(t);
    }

    @Override
    public int getTheoreticalMaximumScore(Team t) {
        Clock c = this.getClock(t);
        int result = c.getDuration() - c.getSecondsPassed();
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    @Override
    public int getFinalScore(Team tm) {
        if (tm.isDisqualified()) {
            return 0;
        }
        boolean[] results = tm.getSubmitTestResults();
        if (results == null) {
            return 0;
        }
        for (int t = 0; t < results.length; ++t) {
            if (results[t]) continue;
            return 0;
        }
        return this.getClock(tm).getDuration() - tm.getSubmitTime();
    }

    @Override
    public int getState(Team t) {
        Clock c = this.getClock(t);
        if (t.isDisqualified()) {
            return 2;
        }
        if (c.isFinished()) {
            return 2;
        }
        if (t.getSubmitTestResults() != null) {
            return 2;
        }
        if (c.isRunning()) {
            return 1;
        }
        if (t.getWorkspace() == null) {
            return 0;
        }
        this.getRWClock(t).start();
        return 1;
    }

    @Override
    public void start(Team tm) {
    }

    @Override
    public void load(Round rnd, Team t, State st) {
        t.load(rnd, st);
        this.getRWClock(t).load(rnd, t, st);
    }
}

