/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.gamerules;

import nl.moj.clock.ReadOnlyClock;
import nl.moj.model.Clock;
import nl.moj.model.GameRules;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;

public class CompetitionGameRules
implements GameRules {
    private Clock readOnlyClock;
    private Clock rwClock;

    public CompetitionGameRules(Clock clock) {
        this.readOnlyClock = new ReadOnlyClock(clock);
        this.rwClock = clock;
    }

    @Override
    public Clock getClock(Team t) {
        return this.readOnlyClock;
    }

    @Override
    public int getTheoreticalMaximumScore(Team t) {
        Clock c = this.getClock(t);
        int result = c.getDuration() - c.getSecondsPassed();
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    @Override
    public int getFinalScore(Team tm) {
        if (tm.isDisqualified()) {
            return 0;
        }
        boolean[] results = tm.getSubmitTestResults();
        if (results == null) {
            return 0;
        }
        for (int t = 0; t < results.length; ++t) {
            if (results[t]) continue;
            return 0;
        }
        return this.getClock(tm).getDuration() - tm.getSubmitTime();
    }

    @Override
    public int getState(Team t) {
        Clock c = this.getClock(t);
        if (t.isDisqualified()) {
            return 2;
        }
        if (c.isFinished()) {
            return 2;
        }
        if (t.getSubmitTestResults() != null) {
            return 2;
        }
        if (c.isRunning() || c.isStarted()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void start(Team tm) {
        if (!this.rwClock.isStarted()) {
            this.rwClock.start();
        }
    }

    @Override
    public void load(Round rnd, Team t, State st) {
        t.load(rnd, st);
        this.rwClock.load(rnd, t, st);
    }
}

