/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.ctrlaltdev.ioc.ApplicationBuilder;
import nl.ctrlaltdev.util.SimpleLogFormatter;
import nl.ctrlaltdev.util.Tool;
import nl.moj.assignment.MoJEclipsePluginAssignment;
import nl.moj.banner.BannerPanel;
import nl.moj.client.ClientApplet;
import nl.moj.clock.ClockPanel;
import nl.moj.clock.SimpleClock;
import nl.moj.compile.Compiler;
import nl.moj.gamerules.CompetitionGameRules;
import nl.moj.gfx.RoundList;
import nl.moj.mgmt.TeamProfileList;
import nl.moj.model.Assignment;
import nl.moj.model.GameRules;
import nl.moj.model.Round;
import nl.moj.model.State;
import nl.moj.model.Team;
import nl.moj.model.Workspace;
import nl.moj.process.ProcessPool;
import nl.moj.round.DoNothingState;
import nl.moj.round.RoundImpl;
import nl.moj.round.TeamImpl;
import nl.moj.scheduler.OneRoundScheduler;
import nl.moj.security.SandboxSecurityManager;
import nl.moj.server.socket.SocketGameServer;
import nl.moj.sfx.SoundEffects;
import nl.moj.workspace.factory.LocalWorkspaceFactory;
import nl.moj.workspace.factory.WorkspaceFactory;

public class AllInOne {
    private static State myState;
    private static State.Writer myStateWriter;
    private static boolean running;
    private static WorkspaceFactory workspaceFactory;

    protected static void buildTeams(Round rnd, ApplicationBuilder root, State.Writer wr, SoundEffects sfx) throws IOException {
        String defaultTeam = "TEAMS=DEFAULT\nDEFAULT.NAME=Default\nDEFAULT.PWD=604F7D0C789F79B50303C9DF83F405ADF3007955\n\n";
        TeamProfileList res = new TeamProfileList(new ByteArrayInputStream(defaultTeam.getBytes()));
        for (int t = 0; t < res.getNumberOfTeams(); ++t) {
            String name = res.getTeamName(t);
            String pwd = res.getPassword(t);
            String displayname = res.getDisplayName(t);
            Assignment assignment = (Assignment)root.get(Assignment.class);
            GameRules gameRules = (GameRules)root.get(GameRules.class);
            TeamImpl ti = new TeamImpl(name, displayname, pwd, assignment, gameRules, wr, sfx);
            Workspace ws = workspaceFactory.createWorkspace(name, ti, ti);
            ti.setWorkspace(ws);
            rnd.addTeam(ti);
        }
    }

    private static void initLogging() throws IOException {
        SimpleLogFormatter.clearLogConfig();
        SimpleLogFormatter.addConsoleLogging();
        SimpleLogFormatter.verbose();
        Logger.getLogger("").log(Level.INFO, "Starting Masters Of Java");
    }

    public static void main(String[] args) throws Throwable {
        System.setProperty("MOJ.ECLIPSEPLUGIN", Boolean.TRUE.toString());
        OutputRedirector.getSingleton();
        args = Tool.parseArgs(args);
        boolean resumeMode = false;
        try {
            new Compiler();
            AllInOne.initLogging();
            File src = new File(args[0]);
            if (!src.exists()) {
                throw new IOException("File '" + src + "' does not exist.");
            }
            ApplicationBuilder root = new ApplicationBuilder();
            root.register(root);
            root.register(ProcessPool.class, new ProcessPool(16));
            root.register(File.class, src);
            root.register(OutputRedirector.class, OutputRedirector.getSingleton());
            ThreadGroup tmp = new ThreadGroup("Tester-ThreadGroup");
            SandboxSecurityManager ssm = new SandboxSecurityManager(tmp);
            System.setSecurityManager(ssm);
            root.build(new Class[]{MoJEclipsePluginAssignment.class});
            DoNothingState ds = new DoNothingState();
            ds.setTimeRemaining(1800);
            root.register(ds);
            myState = (State)root.get(State.class);
            myStateWriter = (State.Writer)root.get(State.Writer.class);
            Logger.getLogger("Using LocalWorkspaceFactory.");
            workspaceFactory = new LocalWorkspaceFactory();
            SoundEffects sfx = new SoundEffects();
            final SimpleClock clock = new SimpleClock(30);
            ClockPanel clockPanel = new ClockPanel(clock, (Assignment)root.get(Assignment.class));
            CompetitionGameRules gameRules = new CompetitionGameRules(clock);
            root.register(clock);
            root.register(gameRules);
            clock.addNotifier(sfx);
            root.build(new Class[]{RoundImpl.class});
            final Round rnd = (Round)root.get(Round.class);
            AllInOne.buildTeams(rnd, root, myStateWriter, sfx);
            rnd.load(myState);
            if (rnd.isStarted() && !resumeMode) {
                if (rnd.isFinished()) {
                    Logger.getLogger("").warning("This round has already finished.");
                    System.exit(0);
                } else {
                    Logger.getLogger("").warning("This round was already started and can only be continued in resume-mode.");
                    System.exit(0);
                }
            } else if (!rnd.isStarted() && resumeMode) {
                Logger.getLogger("").warning("The round was not started, so Resume mode is invalid.");
                resumeMode = false;
                Logger.getLogger("").warning("Cleared RESUME mode.");
            }
            rnd.loadAssignment(resumeMode);
            BannerPanel bp = new BannerPanel(new File("./data/banners/"));
            RoundList rndList = new RoundList(rnd, bp, root);
            clock.addNotifier(bp);
            ThreadGroup theGroup = new ThreadGroup("Elite");
            new SocketGameServer(new OneRoundScheduler(rnd), theGroup);
            final JFrame f = new JFrame("Masters Of Java");
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)clockPanel, "Center");
            f.getContentPane().add((Component)rndList, "East");
            f.setSize(1024, 768);
            f.setVisible(true);
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    if (clock.isRunning()) {
                        f.getToolkit().beep();
                    } else if (clock.isFinished() || !clock.isStarted()) {
                        if (clock.isFinished()) {
                            rnd.dispose();
                        } else {
                            rnd.suspend();
                        }
                        rnd.logReport();
                        Logger.getLogger("").log(Level.INFO, "Terminated by GUI.");
                        running = false;
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        AllInOne.cleanUp(rnd);
                        System.exit(0);
                    } else if (JOptionPane.showConfirmDialog(f, "Terminate Round ?", "Sure ?", 0) == 0) {
                        rnd.suspend();
                        rnd.logReport();
                        Logger.getLogger("").log(Level.INFO, "Terminated by GUI.");
                        running = false;
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        AllInOne.cleanUp(rnd);
                        System.exit(0);
                    }
                }
            });
            KeyAdapter kl = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (clock.isRunning()) {
                        clock.stop();
                    } else {
                        clock.start();
                    }
                }
            };
            clockPanel.addKeyListener(kl);
            running = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (running) {
                        f.repaint();
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }, "Screen Refresh").start();
            clock.start();
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.SEVERE, "Terminated with Exception.", ex);
            ex.printStackTrace();
            System.exit(0);
        }
        args = new String[]{"127.0.0.1"};
        final JFrame f = new JFrame();
        f.setSize(800, 600);
        final ClientApplet ca = new ClientApplet(f, args[0]);
        f.getContentPane().add(ca);
        f.setVisible(true);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ca.canClose()) {
                    ca.stop();
                    ca.destroy();
                    f.dispose();
                }
            }
        });
        ca.init();
        ca.setLogin("Default", "Welkom");
        ca.start();
    }

    private static void cleanUp(Round rnd) {
        Team[] tm = rnd.getAllTeams();
        for (int t = 0; t < tm.length; ++t) {
            tm[t].getWorkspace().dispose();
        }
    }
}

