/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.compile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.ctrlaltdev.io.OutputRedirector;
import nl.moj.model.Workspace;

public class Compiler {
    private static Logger log = Logger.getLogger("Compiler");
    private static final String COMPILERCLASSNAME = "com.sun.tools.javac.Main";
    private static final String COMPILERMETHODNAME = "compile";
    private Method compilerMethod;

    public Compiler() throws ClassNotFoundException, NoSuchMethodException, IOException {
        Class<?> compilerClass = this.getClass().getClassLoader().loadClass(COMPILERCLASSNAME);
        Class[] methodSignature = new Class[]{String[].class, PrintWriter.class};
        this.compilerMethod = compilerClass.getMethod(COMPILERMETHODNAME, methodSignature);
    }

    public boolean compile(Workspace.Internal ws) throws IOException {
        String binRoot = ws.getBinaryRoot().toString().replace('\\', '/');
        String srcRoot = ws.getSourceRoot().toString().replace('\\', '/');
        File[] src = ws.getSourceFiles();
        ArrayList<String> largs = new ArrayList<String>();
        largs.add("-d");
        largs.add(binRoot);
        for (int t = 0; t < src.length; ++t) {
            largs.add(srcRoot + "/" + src[t].getName());
        }
        String[] args = largs.toArray(new String[largs.size()]);
        StringBuffer cmd = new StringBuffer();
        cmd.append("javac ");
        for (int t = 0; t < args.length; ++t) {
            cmd.append(args[t]);
            cmd.append(" ");
        }
        log.log(Level.FINE, cmd.toString());
        long cmp = System.currentTimeMillis();
        boolean result = this.invokeCompiler(args, new OutputRedirector.RedirectorPrintWriter(ws.getTarget())) == 0;
        long delta = System.currentTimeMillis() - cmp;
        log.log(delta > 1000L ? Level.WARNING : Level.INFO, "Compile took : " + delta + " ms");
        if (result) {
            ws.markCompiled();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int invokeCompiler(String[] arguments, PrintWriter out) {
        try {
            Integer i = (Integer)this.compilerMethod.invoke(null, arguments, out);
            return i;
        }
        catch (InvocationTargetException ex) {
            log.log(Level.WARNING, "Compiler-call failed.", ex);
            out.println("Compilation failed.");
            return 1;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Compiler-call failed.", ex);
            out.println("Compilation failed.");
            return 1;
        }
    }
}

