/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.clock;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.moj.clock.SimpleClock;
import nl.moj.model.Assignment;
import nl.moj.model.Clock;

public class ClockPanel
extends JPanel {
    public static final Logger log = Logger.getLogger("Clock-Panel");
    public static final Color[] timeColor = new Color[]{new Color(0x80FF80), new Color(0x80FF80), new Color(0x80FF80), new Color(0x80FF80), new Color(0x80FF80), new Color(0x80FF80), new Color(9502592), new Color(10551168), new Color(11599744), new Color(12648320), new Color(13696896), new Color(14745472), new Color(0xF0FF80), new Color(0xFFFF80), new Color(0xFFF080), new Color(16769152), new Color(16760960), new Color(16756864), new Color(16752768), new Color(16748672), new Color(0xFF8080), new Color(0xFF7070), new Color(0xFF6060), new Color(0xFF5050), new Color(0xFF4040), new Color(0xFF3030), new Color(0xFF2020), new Color(0xFF1010), new Color(0xFF0000), new Color(0xFF0000)};
    private Font textFont = new Font("Verdana", 1, 22);
    private Font smallFont = new Font("Verdana", 0, 12);
    private Clock clock;
    private boolean assignment;
    private String assignmentName;
    private String assignmentAuthor;
    private Image assignmentIcon;
    private Image assignmentSponsor;

    public ClockPanel(Clock c, Assignment a) {
        this.clock = c;
        if (a != null) {
            this.assignment = true;
            this.assignmentName = a.getDisplayName();
            this.assignmentAuthor = "by " + a.getAuthor();
            if (a.getIcon() != null) {
                try {
                    this.assignmentIcon = ImageIO.read(new ByteArrayInputStream(a.getIcon()));
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Unable to read Assignment Icon", ex);
                    this.assignmentIcon = null;
                }
            }
            if (a.getSponsorImage() != null) {
                try {
                    this.assignmentSponsor = ImageIO.read(new ByteArrayInputStream(a.getSponsorImage()));
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Unable to read Assignment Sponsor", ex);
                    this.assignmentSponsor = null;
                }
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (w > h) {
            w = h;
        }
        if (h > w) {
            h = w;
        }
        int rmins = this.clock.getSecondsPassed() / 60;
        int rsecs = this.clock.getSecondsPassed() % 60;
        g2d.translate(w / 2, h / 2);
        Graphics2D local = (Graphics2D)g2d.create();
        try {
            local.rotate(Math.PI);
            double step = 0.10471975511965977;
            for (int t = 0; t < 60; ++t) {
                local.setColor(Color.black);
                if (t % 5 == 0) {
                    local.fillRect(-2, h / 2 - 32, 4, 32);
                } else {
                    local.fillRect(-2, h / 2 - 16, 4, 16);
                }
                if (rmins > t) {
                    int dt = this.clock.getDurationInMinutes() - timeColor.length;
                    if (t >= dt) {
                        local.setColor(timeColor[(t - dt) % timeColor.length]);
                    } else {
                        local.setColor(timeColor[0]);
                    }
                    local.fillArc(-h / 4, -h / 4, h / 2, h / 2, -97, 7);
                }
                if (rsecs == t) {
                    local.setColor(Color.red);
                    local.fillRect(-2, -2, 4, h / 2 - 24);
                }
                local.rotate(step);
            }
            local.setColor(Color.red);
            local.fillArc(-8, -8, 16, 16, 0, 360);
        }
        finally {
            local.dispose();
        }
        g2d.translate(-w / 2, -h / 2);
        if (!this.clock.isRunning()) {
            int tw;
            if (this.assignment && w > 512) {
                int width = 320;
                if (this.assignmentName != null) {
                    width = 150 + this.assignmentName.length() * 16 > 320 ? 150 + this.assignmentName.length() * 16 : 320;
                }
                int left = w / 2 - width / 2;
                int top = 4 * h / 7;
                g.setColor(Color.white);
                g.fillRect(left, top, width, 64);
                g.setColor(Color.lightGray);
                if (this.assignmentIcon != null) {
                    g2d.drawImage(this.assignmentIcon, left + 1, top, null);
                    g.drawRect(left, top, 65, 64);
                }
                if (this.assignmentSponsor != null) {
                    g2d.drawImage(this.assignmentSponsor, left + width - 96, top + 1, null);
                    g.drawRect(left + width - 97, top, 97, 64);
                }
                if (this.assignmentName != null) {
                    g2d.setColor(Color.black);
                    g2d.setFont(this.textFont);
                    g2d.drawString(this.assignmentName, left + 72, top + 22);
                }
                if (this.assignmentAuthor != null) {
                    g2d.setColor(Color.gray);
                    g2d.setFont(this.smallFont);
                    g2d.drawString(this.assignmentAuthor, left + 73, top + 36);
                }
                g.setColor(Color.lightGray);
                g.drawRect(left, top, width, 64);
            }
            if (!this.clock.isFinished()) {
                g2d.setColor(Color.gray);
                String s = "Paused.";
                g2d.setFont(this.textFont);
                tw = g2d.getFontMetrics().stringWidth(s);
                g2d.drawString(s, w / 2 - tw / 2, h * 3 / 4);
                if (this.clock.isStartPosition()) {
                    g2d.setFont(this.smallFont);
                    s = "Press any key to start.";
                    tw = g2d.getFontMetrics().stringWidth(s);
                    g2d.drawString(s, w / 2 - tw / 2, h * 4 / 5);
                }
            } else {
                g2d.setColor(Color.gray);
                String s = "The End !";
                g2d.setFont(this.textFont);
                tw = g2d.getFontMetrics().stringWidth(s);
                g2d.drawString(s, w / 2 - tw / 2, h * 4 / 5);
            }
        }
    }

    public static void main(String[] args) {
        final SimpleClock clock = new SimpleClock(60);
        JFrame f = new JFrame("Masters Of Java");
        f.setSize(512, 512);
        final ClockPanel cp = new ClockPanel(clock, null);
        f.getContentPane().add(cp);
        Timer tm = new Timer();
        tm.schedule(new TimerTask(){

            @Override
            public void run() {
                clock.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cp.repaint();
                    }
                });
            }
        }, 250L, 250L);
        clock.start();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        cp.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!clock.isRunning()) {
                    clock.start();
                } else {
                    clock.stop();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        f.setVisible(true);
    }
}

