/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;

public class UpdateClientStatisticsMessageImpl
extends AbstractMessage
implements Message.UpdateClientStatistics {
    private int myFinal;
    private int myMaxSec;
    private int mySecRemain;
    private int myState;
    private int myTeamsOnline;
    private int myTeamCount;
    private int[] myResults;

    public UpdateClientStatisticsMessageImpl(int finalScore, int maxSec, int secRemain, int state, int teamsOnline, int teamCount, int[] results) {
        super(4);
        this.myFinal = finalScore;
        this.myMaxSec = maxSec;
        this.mySecRemain = secRemain;
        this.myState = state;
        this.myTeamsOnline = teamsOnline;
        this.myTeamCount = teamCount;
        this.myResults = results;
    }

    public UpdateClientStatisticsMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 4) {
            throw new IOException("Incorrect Type");
        }
        this.myFinal = in.readInt();
        this.myMaxSec = in.readInt();
        this.mySecRemain = in.readInt();
        this.myState = in.readInt();
        this.myTeamsOnline = in.readInt();
        this.myTeamCount = in.readInt();
        int cnt = in.readInt();
        this.myResults = new int[cnt];
        if (cnt == 0) {
            this.myResults = null;
        } else {
            for (int t = 0; t < cnt; ++t) {
                this.myResults[t] = in.readInt();
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.myFinal);
        out.writeInt(this.myMaxSec);
        out.writeInt(this.mySecRemain);
        out.writeInt(this.myState);
        out.writeInt(this.myTeamsOnline);
        out.writeInt(this.myTeamCount);
        if (this.myResults == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.myResults.length);
            for (int t = 0; t < this.myResults.length; ++t) {
                out.writeInt(this.myResults[t]);
            }
        }
    }

    @Override
    public int getFinalScore() {
        return this.myFinal;
    }

    @Override
    public int getMaxSeconds() {
        return this.myMaxSec;
    }

    @Override
    public int getSecondsRemaining() {
        return this.mySecRemain;
    }

    @Override
    public int getState() {
        return this.myState;
    }

    @Override
    public int getTeamsOnline() {
        return this.myTeamsOnline;
    }

    @Override
    public int getTeamCount() {
        return this.myTeamCount;
    }

    @Override
    public int[] getTestResults() {
        return this.myResults;
    }
}

