/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;

public class TestSetMessageImpl
extends AbstractMessage
implements Message.TestSet {
    private String[] myNames;
    private String[] myDescriptions;

    public TestSetMessageImpl(String[] names, String[] descriptions) {
        super(8);
        if (names.length != descriptions.length) {
            throw new RuntimeException("names do not match descriptions.");
        }
        this.myNames = names;
        this.myDescriptions = descriptions;
    }

    public TestSetMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 8) {
            throw new IOException("Incorrect Type");
        }
        int myCnt = in.readInt();
        this.myNames = new String[myCnt];
        this.myDescriptions = new String[myCnt];
        for (int t = 0; t < myCnt; ++t) {
            this.myNames[t] = in.readUTF();
            this.myDescriptions[t] = in.readUTF();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.myNames.length);
        for (int t = 0; t < this.myNames.length; ++t) {
            out.writeUTF(this.myNames[t]);
            out.writeUTF(this.myDescriptions[t]);
        }
    }

    @Override
    public int getCount() {
        return this.myNames.length;
    }

    @Override
    public String getDescription(int nr) {
        return this.myDescriptions[nr];
    }

    @Override
    public String getName(int nr) {
        return this.myNames[nr];
    }
}

