/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.anim.Anim;

public interface Message {
    public static final int PROTOCOLVERSION = 2007111001;
    public static final int MSG_HELLO = 0;
    public static final int MSG_EDITOR = 1;
    public static final int MSG_CONSOLE = 2;
    public static final int MSG_ACTION = 3;
    public static final int MSG_UPDATE_CLIENT = 4;
    public static final int MSG_ADDACTION = 6;
    public static final int MSG_UNKNOWNUSERPASSWORD = 7;
    public static final int MSG_TESTSET = 8;
    public static final int MSG_PROTOCOLVERSIONMISMATCH = 9;
    public static final int MSG_ANIMATION = 10;
    public static final int MSG_NOOP = 11;
    public static final int MSG_GOODBYE = 12;
    public static final int MSG_ASSIGNMENT = 13;

    public int getId();

    public int getSourceId();

    public int getType();

    public void write(DataOutput var1) throws IOException;

    public static interface Assignment
    extends Message {
        public String getName();

        public String getAuthor();

        public byte[] getIcon();

        public byte[] getSponsorImage();
    }

    public static interface Animation
    extends Message {
        public int getTest();

        public Anim getAnimation();
    }

    public static interface UpdateClientStatistics
    extends Message {
        public static final int STATE_WAIT = 0;
        public static final int STATE_PROGRAMMING = 1;
        public static final int STATE_FINISHED = 2;

        public int getState();

        public int getMaxSeconds();

        public int getSecondsRemaining();

        public int getFinalScore();

        public int getTeamsOnline();

        public int getTeamCount();

        public int[] getTestResults();
    }

    public static interface Action
    extends Message {
        public String getAction();

        public String getFileName();

        public String getContents();

        public int getIndex();

        public int getKeyStrokes();
    }

    public static interface TestSet
    extends Message {
        public int getCount();

        public String getName(int var1);

        public String getDescription(int var1);
    }

    public static interface GoodBye
    extends Message {
    }

    public static interface NoOp
    extends Message {
    }

    public static interface AddAction
    extends Message {
        public String getAction();

        public boolean mustConfirm();

        public String getToolTip();
    }

    public static interface Console
    extends Message {
        public String getConsole();

        public String getContent();
    }

    public static interface Editor
    extends Message {
        public String getFileName();

        public String getContents();

        public boolean isJava();

        public boolean isReadOnly();

        public boolean isMonospaced();
    }

    public static interface Hello
    extends Message {
        public String getTeamName();

        public String getPassword();

        public int getProtocolVersion();
    }
}

