/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;

public class EditorMessageImpl
extends AbstractMessage
implements Message.Editor {
    private String myFile;
    private String myContents;
    private boolean myIsJava;
    private boolean myIsReadOnly;
    private boolean myIsMonospaced;

    public EditorMessageImpl(String fileName, String contents, boolean isJava, boolean isReadOnly, boolean monospaced) {
        super(1);
        this.myFile = fileName;
        this.myContents = contents;
        this.myIsJava = isJava;
        this.myIsReadOnly = isReadOnly;
        this.myIsMonospaced = monospaced;
    }

    public EditorMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 1) {
            throw new IOException("Incorrect Type");
        }
        this.myFile = in.readUTF();
        this.myContents = in.readUTF();
        this.myIsJava = in.readBoolean();
        this.myIsReadOnly = in.readBoolean();
        this.myIsMonospaced = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myFile);
        out.writeUTF(this.myContents);
        out.writeBoolean(this.myIsJava);
        out.writeBoolean(this.myIsReadOnly);
        out.writeBoolean(this.myIsMonospaced);
    }

    @Override
    public String getContents() {
        return this.myContents;
    }

    @Override
    public String getFileName() {
        return this.myFile;
    }

    @Override
    public boolean isJava() {
        return this.myIsJava;
    }

    @Override
    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    @Override
    public boolean isMonospaced() {
        return this.myIsMonospaced;
    }
}

