/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nl.moj.client.io.AbstractMessage;
import nl.moj.client.io.Message;
import nl.moj.model.Assignment;

public class AssignmentMessageImpl
extends AbstractMessage
implements Message.Assignment {
    private String myName;
    private String myAuthor;
    private byte[] myIcon;
    private byte[] mySponsor;

    public AssignmentMessageImpl(Assignment a) {
        super(13);
        this.myName = a.getDisplayName() == null ? "Unknown" : a.getDisplayName();
        this.myAuthor = a.getAuthor() == null ? "Unknown" : a.getAuthor();
        this.myIcon = a.getIcon() == null ? null : a.getIcon();
        this.mySponsor = a.getSponsorImage() == null ? null : a.getSponsorImage();
    }

    public AssignmentMessageImpl(int type, DataInput in) throws IOException {
        super(type, in);
        if (type != 13) {
            throw new IOException("Incorrect Type");
        }
        this.myName = in.readUTF();
        this.myAuthor = in.readUTF();
        int l = in.readInt();
        if (l >= 0) {
            this.myIcon = new byte[l];
            in.readFully(this.myIcon);
        }
        if ((l = in.readInt()) >= 0) {
            this.mySponsor = new byte[l];
            in.readFully(this.mySponsor);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myName);
        out.writeUTF(this.myAuthor);
        if (this.myIcon != null) {
            out.writeInt(this.myIcon.length);
            out.write(this.myIcon);
        } else {
            out.writeInt(-1);
        }
        if (this.mySponsor != null) {
            out.writeInt(this.mySponsor.length);
            out.write(this.mySponsor);
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getAuthor() {
        return this.myAuthor;
    }

    @Override
    public byte[] getIcon() {
        return this.myIcon;
    }

    @Override
    public byte[] getSponsorImage() {
        return this.mySponsor;
    }
}

