/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import nl.moj.client.codecompletion.statement.AbstractCompoundStatement;
import nl.moj.client.codecompletion.statement.AbstractStatement;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;

public class VariableDeclarationStatement
extends AbstractCompoundStatement {
    private AbstractStatement myParent;
    private String myType;
    private String myName;

    public VariableDeclarationStatement(AbstractStatement parent, int pos, String[] words) {
        super(words, pos);
        this.myParent = parent;
        this.myType = words[0];
        if (words[1].equals("[]")) {
            this.myType = this.myType + "[]";
            this.myName = words[2];
        } else {
            this.myName = words[1];
        }
    }

    @Override
    public Statement getParent() {
        return this.myParent;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getType() {
        Statement p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        if (this.isArray()) {
            return ((JavaFile)p).expandImport(this.myType.substring(0, this.myType.length() - 2)) + "[]";
        }
        return ((JavaFile)p).expandImport(this.myType);
    }

    public boolean isArray() {
        return this.myType.endsWith("[]");
    }

    public Declaration getDeclaration() {
        return new Declaration(this.getType(), this.getName(), this.isArray());
    }

    public static boolean qualifies(String[] words) {
        if (words.length < 2) {
            return false;
        }
        if (VariableDeclarationStatement.isModifier(words[0])) {
            return false;
        }
        if (VariableDeclarationStatement.isModifier(words[1])) {
            return false;
        }
        if (VariableDeclarationStatement.isPrimitive(words[1])) {
            return false;
        }
        if (VariableDeclarationStatement.isCommand(words[0])) {
            return false;
        }
        if (VariableDeclarationStatement.isCommand(words[1])) {
            return false;
        }
        if (words.length > 2 && (words[1].equals("[]") ? !words[3].equals("=") : !words[2].equals("="))) {
            return false;
        }
        if (VariableDeclarationStatement.isPrimitive(words[0])) {
            return true;
        }
        return true;
    }

    @Override
    public String toString() {
        return "VariableDeclaration(" + this.myName + " of type " + this.getType() + ")";
    }
}

