/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import java.util.ArrayList;
import nl.moj.client.codecompletion.statement.ClassStatement;
import nl.moj.client.codecompletion.statement.CompoundStatement;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementException;

public class InterfaceStatement
extends DeclarationStatement {
    private String myName;
    private String[] myInterfaces;
    private CompoundStatement myParent;

    public InterfaceStatement(CompoundStatement parent, int pos, String[] words) {
        super(words, pos);
        int t;
        this.myParent = parent;
        boolean isInterface = false;
        boolean isExtends = false;
        ArrayList<String> interfaces = new ArrayList<String>();
        for (t = 0; t < words.length; ++t) {
            if (InterfaceStatement.isModifier(words[t])) continue;
            if ("interface".equals(words[t])) {
                isInterface = true;
                continue;
            }
            if ("extends".equals(words[t])) {
                isExtends = true;
                continue;
            }
            if (isInterface) {
                this.myName = words[t];
                isInterface = false;
                continue;
            }
            if (isExtends) {
                interfaces.add(words[t]);
                continue;
            }
            throw new StatementException("Incorrectly formatted Interface Statement : " + this);
        }
        this.myInterfaces = interfaces.toArray(new String[interfaces.size()]);
        for (t = 0; t < this.myInterfaces.length; ++t) {
            this.myInterfaces[t] = this.getJavaFile().expandImport(this.myInterfaces[t]);
        }
        if (this.myName == null) {
            throw new StatementException("Missing name : " + this);
        }
    }

    private JavaFile getJavaFile() {
        Statement p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return (JavaFile)p;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String[] getExtendedInterfaces() {
        return this.myInterfaces;
    }

    public static boolean qualifies(String[] words) {
        return InterfaceStatement.contains(words, "interface");
    }

    @Override
    public Statement getParent() {
        return this.myParent;
    }

    public ClassStatement[] getClasses() {
        ArrayList results = new ArrayList();
        this.scan(results, ClassStatement.class);
        return results.toArray(new ClassStatement[results.size()]);
    }

    public InterfaceStatement[] getInterfaces() {
        ArrayList results = new ArrayList();
        this.scan(results, InterfaceStatement.class);
        return results.toArray(new InterfaceStatement[results.size()]);
    }

    public DeclarationStatement[] getTypes() {
        ArrayList results = new ArrayList();
        this.scan(results, ClassStatement.class);
        this.scan(results, InterfaceStatement.class);
        return results.toArray(new DeclarationStatement[results.size()]);
    }
}

