/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import nl.moj.client.codecompletion.statement.AbstractCompoundStatement;
import nl.moj.client.codecompletion.statement.ClassStatement;
import nl.moj.client.codecompletion.statement.InterfaceStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;

public abstract class DeclarationStatement
extends AbstractCompoundStatement {
    public DeclarationStatement(String[] words, int pos) {
        super(words, pos);
    }

    public boolean isPublic() {
        return this.contains("public");
    }

    public boolean isProtected() {
        return this.contains("protected");
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isPrivate() {
        return this.contains("private");
    }

    public boolean isStatic() {
        return this.contains("static");
    }

    @Override
    public abstract String getName();

    public String getFullyQualifiedName() {
        String fqname = this.getName();
        Statement p = this;
        while (p.getParent() != null) {
            if ((p = p.getParent()) instanceof ClassStatement) {
                fqname = ((ClassStatement)p).getName() + "." + fqname;
                continue;
            }
            if (!(p instanceof InterfaceStatement)) continue;
            fqname = ((InterfaceStatement)p).getName() + "." + fqname;
        }
        String pkg = ((JavaFile)p).getPackage().getPackage();
        return pkg.length() == 0 ? fqname : pkg + "." + fqname;
    }

    public String findFullyQualifiedName(String name) {
        if (name.indexOf(60) >= 0) {
            name = name.substring(0, name.indexOf(60));
        }
        Statement p = this;
        while (p.getParent() != null) {
            int t;
            DeclarationStatement[] ds;
            DeclarationStatement cs;
            if ((p = p.getParent()) instanceof ClassStatement) {
                cs = (ClassStatement)p;
                if (((ClassStatement)cs).getName().equals(name)) {
                    return cs.getFullyQualifiedName();
                }
                ds = ((ClassStatement)cs).getTypes();
                for (t = 0; t < ds.length; ++t) {
                    if (!ds[t].getName().equals(name)) continue;
                    return ds[t].getFullyQualifiedName();
                }
                continue;
            }
            if (!(p instanceof InterfaceStatement)) continue;
            cs = (InterfaceStatement)p;
            if (((InterfaceStatement)cs).getName().equals(name)) {
                return cs.getFullyQualifiedName();
            }
            ds = ((InterfaceStatement)cs).getTypes();
            for (t = 0; t < ds.length; ++t) {
                if (!ds[t].getName().equals(name)) continue;
                return ds[t].getFullyQualifiedName();
            }
        }
        return ((JavaFile)p).expandImport(name);
    }
}

