/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion.statement;

import java.util.ArrayList;
import nl.moj.client.codecompletion.statement.CompoundStatement;
import nl.moj.client.codecompletion.statement.Declaration;
import nl.moj.client.codecompletion.statement.DeclarationStatement;
import nl.moj.client.codecompletion.statement.InterfaceStatement;
import nl.moj.client.codecompletion.statement.JavaFile;
import nl.moj.client.codecompletion.statement.Statement;
import nl.moj.client.codecompletion.statement.StatementException;

public class ClassStatement
extends DeclarationStatement {
    private String myName = null;
    private String mySuperClass = null;
    private String[] myInterfaces;
    private CompoundStatement myParent;

    public ClassStatement(CompoundStatement parent, int pos, String[] words) {
        super(words, pos);
        this.myParent = parent;
        boolean isImplements = false;
        boolean isClass = false;
        boolean isExtends = false;
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int t = 0; t < words.length; ++t) {
            if (ClassStatement.isModifier(words[t])) continue;
            if (this.getClassWord().equals(words[t])) {
                isClass = true;
                continue;
            }
            if ("extends".equals(words[t])) {
                isExtends = true;
                isClass = false;
                continue;
            }
            if ("implements".equals(words[t])) {
                isImplements = true;
                isExtends = false;
                isClass = false;
                continue;
            }
            if (isClass) {
                if (this.myName != null) {
                    throw new StatementException("Double Class name : " + this);
                }
                this.myName = words[t];
                continue;
            }
            if (isExtends) {
                if (this.mySuperClass != null) {
                    throw new StatementException("Two Parent Classes : " + this);
                }
                this.mySuperClass = words[t];
                continue;
            }
            if (isImplements) {
                interfaces.add(words[t]);
                continue;
            }
            throw new StatementException("Incorrectly formatted Class Statement : " + this);
        }
        this.myInterfaces = interfaces.toArray(new String[interfaces.size()]);
        if (this.myName == null) {
            throw new StatementException("Missing name : " + this);
        }
        if (this.mySuperClass == null) {
            this.mySuperClass = "java.lang.Object";
        }
    }

    protected void setSuperClass(String s) {
        if (s == null) {
            s = "java.lang.Object";
        }
        this.mySuperClass = s;
    }

    protected String getClassWord() {
        return "class";
    }

    public boolean isInnerClass() {
        return this.getParent() instanceof ClassStatement;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getSuperClassName() {
        return this.getJavaFile().expandImport(this.mySuperClass);
    }

    public String[] getInterfaceNames() {
        String[] tmp = new String[this.myInterfaces.length];
        for (int t = 0; t < this.myInterfaces.length; ++t) {
            tmp[t] = this.getJavaFile().expandImport(this.myInterfaces[t]);
        }
        return tmp;
    }

    private JavaFile getJavaFile() {
        Statement p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return (JavaFile)p;
    }

    public ClassStatement[] getClasses() {
        ArrayList results = new ArrayList();
        this.scan(results, ClassStatement.class);
        return results.toArray(new ClassStatement[results.size()]);
    }

    public InterfaceStatement[] getInterfaces() {
        ArrayList results = new ArrayList();
        this.scan(results, InterfaceStatement.class);
        return results.toArray(new InterfaceStatement[results.size()]);
    }

    public DeclarationStatement[] getTypes() {
        ArrayList results = new ArrayList();
        this.scan(results, ClassStatement.class);
        this.scan(results, InterfaceStatement.class);
        return results.toArray(new DeclarationStatement[results.size()]);
    }

    public static boolean qualifies(String[] words) {
        return ClassStatement.contains(words, "class");
    }

    @Override
    public Statement getParent() {
        return this.myParent;
    }

    public Declaration getDeclaration() {
        return new Declaration(this.getFullyQualifiedName(), this.getName(), false);
    }
}

