/*
 * Decompiled with CFR 0.152.
 */
package nl.moj.client.codecompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import nl.ctrlaltdev.util.Tool;
import nl.moj.client.codecompletion.CodeNodeFactory;
import nl.moj.client.codecompletion.TypeCodeCompletion;

public abstract class CodeNode
implements Comparable<CodeNode> {
    private static final CodeNode[] NOTHING = new CodeNode[0];
    private String myName;
    private boolean myIsStatic;
    private boolean isLazy;
    private boolean isArray;
    private CodeNode myParent;

    public CodeNode(CodeNode parent, String name, boolean isStatic) {
        this(parent, name, isStatic, false, false);
    }

    public CodeNode(CodeNode parent, String name, boolean isStatic, boolean isLazy, boolean isArray) {
        this.myName = name;
        this.myIsStatic = isStatic;
        this.myParent = parent;
        this.isLazy = isLazy;
        this.isArray = isArray;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    protected void clearLazy() {
        this.isLazy = false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    protected CodeNode getRoot() {
        if (this.getParent() != null) {
            return this.getParent().getRoot();
        }
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isBranch() {
        return this.getLeafNodes().length > 0;
    }

    public abstract CodeNode[] getLeafNodes();

    public CodeNode contains(String name) {
        CodeNode[] cn = this.getLeafNodes();
        for (int t = 0; t < cn.length; ++t) {
            if (!cn[t].getName().equals(name)) continue;
            return cn[t];
        }
        return null;
    }

    public void find(String nodeName, boolean partial, boolean isStatic, Set<CodeNode> results) {
        if (this.match(nodeName, partial, isStatic)) {
            results.add(this);
        }
        this.findChildren(nodeName, partial, isStatic, results);
    }

    public boolean isRoot() {
        return this.myName.length() == 0;
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public boolean containsPath(String s) {
        return this.findPath(Tool.cut(s, ".")) != null;
    }

    public CodeNode findPath(String[] s) {
        if (s.length == 0) {
            return this;
        }
        if (this.match(s[0], false, true) || this.match(s[0], false, false) || this.isRoot()) {
            if (s.length == 1) {
                return this;
            }
            CodeNode[] cn = this.getLeafNodes();
            if (!this.isRoot()) {
                String[] ss = new String[s.length - 1];
                System.arraycopy(s, 1, ss, 0, ss.length);
                s = ss;
            }
            for (int t = 0; t < cn.length; ++t) {
                CodeNode found = cn[t].findPath(s);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public CodeNode findPath(String s) {
        return this.findPath(Tool.cut(s, "."));
    }

    public void findChildren(String nodeName, boolean partial, boolean isStatic, Set<CodeNode> results) {
        CodeNode[] cn = this.getLeafNodes();
        for (int t = 0; t < cn.length; ++t) {
            cn[t].find(nodeName, partial, isStatic, results);
        }
    }

    protected void resolveReference() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public boolean match(String nodeName, boolean partial, boolean isStatic) {
        if (this.myIsStatic ? !isStatic : !this.myIsStatic && isStatic) {
            return false;
        }
        if (partial) {
            return this.myName.startsWith(nodeName);
        }
        return this.myName.equals(nodeName);
    }

    public CodeNode getParent() {
        return this.myParent;
    }

    public String toString() {
        return "CodeNode(" + this.myName + ")";
    }

    @Override
    public int compareTo(CodeNode o) {
        return o.getName().compareTo(this.myName);
    }

    public String render() {
        StringBuffer sb = new StringBuffer();
        this.render(sb, 0);
        return sb.toString();
    }

    protected void render(StringBuffer sb, int indent) {
        for (int t = 0; t < indent; ++t) {
            sb.append("| ");
        }
        sb.append("+-");
        sb.append(this.myName);
        sb.append("\n");
        CodeNode[] cn = this.getLeafNodes();
        for (int t = 0; t < cn.length; ++t) {
            cn[t].render(sb, indent + 1);
        }
    }

    public String getFullPath() {
        CodeNode p = this.getParent();
        if (p != null) {
            String fp = p.getFullPath();
            if (fp.length() == 0) {
                return this.getName();
            }
            return fp + "." + this.getName();
        }
        return this.getName();
    }

    public void addLink(CodeNode cc) {
        throw new UnsupportedOperationException("");
    }

    public static class ReferenceNode
    extends CodeNode {
        private CodeNode reference;

        public ReferenceNode(CodeNode parent, String name, CodeNode node, boolean isStatic, boolean isArray) {
            super(parent, name, isStatic, false, isArray);
            this.reference = node;
        }

        @Override
        public CodeNode[] getLeafNodes() {
            return this.reference.getLeafNodes();
        }

        @Override
        public void find(String nodeName, boolean partial, boolean isStatic, Set<CodeNode> results) {
            if (this.match(nodeName, partial, isStatic)) {
                results.add(this);
            }
        }

        @Override
        protected void render(StringBuffer sb, int indent) {
            for (int t = 0; t < indent; ++t) {
                sb.append("| ");
            }
            sb.append("+-");
            sb.append(this.getName() + " --> " + this.reference.getFullPath() + (this.isArray() ? "[]" : ""));
            sb.append("\n");
        }

        public CodeNode asArrayNode() {
            return new ReferenceNode(this.getParent(), this.getName(), this.reference, this.isStatic(), true);
        }
    }

    public static class BranchNode
    extends CodeNode {
        private List<CodeNode> mySubNodes = new ArrayList<CodeNode>();
        private Set<CodeNode> myLinkedNodes = new TreeSet<CodeNode>();
        private CodeNodeFactory cnf;

        public BranchNode(CodeNode parent, String name, boolean isStatic) {
            super(parent, name, isStatic);
        }

        public BranchNode(CodeNode parent, String name, boolean isStatic, boolean isLazy, CodeNodeFactory cnf) {
            super(parent, name, isStatic, isLazy, false);
            this.cnf = cnf;
        }

        public BranchNode(CodeNode parent, String name, boolean isStatic, boolean isLazy, CodeNodeFactory cnf, boolean isArray) {
            super(parent, name, isStatic, isLazy, isArray);
            this.cnf = cnf;
        }

        public void addNode(CodeNode n) {
            this.mySubNodes.add(n);
        }

        @Override
        public CodeNode[] getLeafNodes() {
            if (this.isLazy()) {
                this.clearLazy();
                new TypeCodeCompletion(this.getFullPath()).addToCodeTree(this.cnf, this.getRoot());
                this.cnf = null;
            }
            ArrayList<CodeNode> tmp = new ArrayList<CodeNode>();
            tmp.addAll(this.mySubNodes);
            for (CodeNode c : this.myLinkedNodes) {
                tmp.addAll(Arrays.asList(c.getLeafNodes()));
            }
            return tmp.toArray(new CodeNode[tmp.size()]);
        }

        @Override
        public void addLink(CodeNode link) {
            if (link == null) {
                return;
            }
            if (this.equals(link)) {
                throw new RuntimeException("Cannot be one's own child.");
            }
            this.myLinkedNodes.add(link);
        }

        public CodeNode asArrayNode() {
            BranchNode bn = new BranchNode(this.getParent(), this.getName(), this.isStatic(), this.isLazy(), this.cnf, true);
            bn.myLinkedNodes = this.myLinkedNodes;
            bn.mySubNodes = this.mySubNodes;
            return bn;
        }
    }

    public static class LeafNode
    extends CodeNode {
        public LeafNode(CodeNode parent, String name, boolean isStatic) {
            super(parent, name, isStatic);
        }

        @Override
        public CodeNode[] getLeafNodes() {
            return NOTHING;
        }
    }
}

